package odata.msgraph.client.beta.callRecords.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ProductFamily implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("teams")
    TEAMS("teams", "1"),

    @JsonProperty("skypeForBusiness")
    SKYPE_FOR_BUSINESS("skypeForBusiness", "2"),

    @JsonProperty("lync")
    LYNC("lync", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4"),

    @JsonProperty("azureCommunicationServices")
    AZURE_COMMUNICATION_SERVICES("azureCommunicationServices", "5");

    private final String name;
    private final String value;

    private ProductFamily(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
