package odata.msgraph.client.beta.callRecords.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.entity.CallRecord;
import odata.msgraph.client.beta.callRecords.entity.collection.request.SessionCollectionRequest;

@JsonIgnoreType
public class CallRecordRequest extends EntityRequest<CallRecord> {

    public CallRecordRequest(ContextPath contextPath, Optional<Object> value) {
        super(CallRecord.class, contextPath, value, false);
    }

    public SessionRequest sessions(String id) {
        return new SessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SessionCollectionRequest sessions() {
        return new SessionCollectionRequest(
                        contextPath.addSegment("sessions"), Optional.empty());
    }

}
