package odata.msgraph.client.beta.callRecords.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.entity.collection.request.SessionCollectionRequest;
import odata.msgraph.client.beta.callRecords.enums.CallType;
import odata.msgraph.client.beta.callRecords.enums.Modality;
import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "endDateTime", 
    "joinWebUrl", 
    "lastModifiedDateTime", 
    "modalities", 
    "organizer", 
    "participants", 
    "startDateTime", 
    "type", 
    "version", 
    "sessions"})
@JsonInclude(Include.NON_NULL)
public class CallRecord extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.callRecord";
    }

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("joinWebUrl")
    protected String joinWebUrl;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("modalities")
    protected List<Modality> modalities;

    @JsonProperty("modalities@nextLink")
    protected String modalitiesNextLink;

    @JsonProperty("organizer")
    protected IdentitySet organizer;

    @JsonProperty("participants")
    protected List<IdentitySet> participants;

    @JsonProperty("participants@nextLink")
    protected String participantsNextLink;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("type")
    protected CallType type;

    @JsonProperty("version")
    protected Long version;

    @JsonProperty("sessions")
    protected List<Session> sessions;

    protected CallRecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCallRecord() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime endDateTime;
        private String joinWebUrl;
        private OffsetDateTime lastModifiedDateTime;
        private List<Modality> modalities;
        private String modalitiesNextLink;
        private IdentitySet organizer;
        private List<IdentitySet> participants;
        private String participantsNextLink;
        private OffsetDateTime startDateTime;
        private CallType type;
        private Long version;
        private List<Session> sessions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder joinWebUrl(String joinWebUrl) {
            this.joinWebUrl = joinWebUrl;
            this.changedFields = changedFields.add("joinWebUrl");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder modalities(List<Modality> modalities) {
            this.modalities = modalities;
            this.changedFields = changedFields.add("modalities");
            return this;
        }

        public Builder modalities(Modality... modalities) {
            return modalities(Arrays.asList(modalities));
        }

        public Builder modalitiesNextLink(String modalitiesNextLink) {
            this.modalitiesNextLink = modalitiesNextLink;
            this.changedFields = changedFields.add("modalities");
            return this;
        }

        public Builder organizer(IdentitySet organizer) {
            this.organizer = organizer;
            this.changedFields = changedFields.add("organizer");
            return this;
        }

        public Builder participants(List<IdentitySet> participants) {
            this.participants = participants;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public Builder participants(IdentitySet... participants) {
            return participants(Arrays.asList(participants));
        }

        public Builder participantsNextLink(String participantsNextLink) {
            this.participantsNextLink = participantsNextLink;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder type(CallType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder version(Long version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder sessions(List<Session> sessions) {
            this.sessions = sessions;
            this.changedFields = changedFields.add("sessions");
            return this;
        }

        public Builder sessions(Session... sessions) {
            return sessions(Arrays.asList(sessions));
        }

        public CallRecord build() {
            CallRecord _x = new CallRecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.callRecord";
            _x.id = id;
            _x.endDateTime = endDateTime;
            _x.joinWebUrl = joinWebUrl;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.modalities = modalities;
            _x.modalitiesNextLink = modalitiesNextLink;
            _x.organizer = organizer;
            _x.participants = participants;
            _x.participantsNextLink = participantsNextLink;
            _x.startDateTime = startDateTime;
            _x.type = type;
            _x.version = version;
            _x.sessions = sessions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public CallRecord withEndDateTime(OffsetDateTime endDateTime) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="joinWebUrl")
    @JsonIgnore
    public Optional<String> getJoinWebUrl() {
        return Optional.ofNullable(joinWebUrl);
    }

    public CallRecord withJoinWebUrl(String joinWebUrl) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("joinWebUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.joinWebUrl = joinWebUrl;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CallRecord withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="modalities")
    @JsonIgnore
    public CollectionPage<Modality> getModalities() {
        return new CollectionPage<Modality>(contextPath, Modality.class, this.modalities, Optional.ofNullable(modalitiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public CallRecord withModalities(List<Modality> modalities) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("modalities");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.modalities = modalities;
        return _x;
    }

    @Property(name="modalities")
    @JsonIgnore
    public CollectionPage<Modality> getModalities(HttpRequestOptions options) {
        return new CollectionPage<Modality>(contextPath, Modality.class, this.modalities, Optional.ofNullable(modalitiesNextLink), Collections.emptyList(), options);
    }

    @Property(name="organizer")
    @JsonIgnore
    public Optional<IdentitySet> getOrganizer() {
        return Optional.ofNullable(organizer);
    }

    public CallRecord withOrganizer(IdentitySet organizer) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("organizer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.organizer = organizer;
        return _x;
    }

    @Property(name="participants")
    @JsonIgnore
    public CollectionPage<IdentitySet> getParticipants() {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, this.participants, Optional.ofNullable(participantsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public CallRecord withParticipants(List<IdentitySet> participants) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("participants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.participants = participants;
        return _x;
    }

    @Property(name="participants")
    @JsonIgnore
    public CollectionPage<IdentitySet> getParticipants(HttpRequestOptions options) {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, this.participants, Optional.ofNullable(participantsNextLink), Collections.emptyList(), options);
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public CallRecord withStartDateTime(OffsetDateTime startDateTime) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<CallType> getType() {
        return Optional.ofNullable(type);
    }

    public CallRecord withType(CallType type) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.type = type;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<Long> getVersion() {
        return Optional.ofNullable(version);
    }

    public CallRecord withVersion(Long version) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.version = version;
        return _x;
    }

    public CallRecord withUnmappedField(String name, Object value) {
        CallRecord _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="sessions")
    @JsonIgnore
    public SessionCollectionRequest getSessions() {
        return new SessionCollectionRequest(
                        contextPath.addSegment("sessions"), Optional.ofNullable(sessions));
    }

    public CallRecord withSessions(List<Session> sessions) {
        CallRecord _x = _copy();
        _x.changedFields = changedFields.add("sessions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.callRecord");
        _x.sessions = sessions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CallRecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CallRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CallRecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CallRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CallRecord _copy() {
        CallRecord _x = new CallRecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.endDateTime = endDateTime;
        _x.joinWebUrl = joinWebUrl;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.modalities = modalities;
        _x.organizer = organizer;
        _x.participants = participants;
        _x.startDateTime = startDateTime;
        _x.type = type;
        _x.version = version;
        _x.sessions = sessions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CallRecord[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("joinWebUrl=");
        b.append(this.joinWebUrl);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("modalities=");
        b.append(this.modalities);
        b.append(", ");
        b.append("organizer=");
        b.append(this.organizer);
        b.append(", ");
        b.append("participants=");
        b.append(this.participants);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("sessions=");
        b.append(this.sessions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
