package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.ServiceRole;

@JsonPropertyOrder({
    "@odata.type", 
    "role"})
@JsonInclude(Include.NON_NULL)
public class ServiceUserAgent extends UserAgent implements ODataType {

    @JsonProperty("role")
    protected ServiceRole role;

    protected ServiceUserAgent() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.serviceUserAgent";
    }

    @Property(name="role")
    @JsonIgnore
    public Optional<ServiceRole> getRole() {
        return Optional.ofNullable(role);
    }

    public ServiceUserAgent withRole(ServiceRole role) {
        ServiceUserAgent _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.serviceUserAgent");
        _x.role = role;
        return _x;
    }

    public ServiceUserAgent withUnmappedField(String name, Object value) {
        ServiceUserAgent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServiceUserAgent() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationVersion;
        private String headerValue;
        private ServiceRole role;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            this.changedFields = changedFields.add("applicationVersion");
            return this;
        }

        public Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            this.changedFields = changedFields.add("headerValue");
            return this;
        }

        public Builder role(ServiceRole role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public ServiceUserAgent build() {
            ServiceUserAgent _x = new ServiceUserAgent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.serviceUserAgent";
            _x.applicationVersion = applicationVersion;
            _x.headerValue = headerValue;
            _x.role = role;
            return _x;
        }
    }

    private ServiceUserAgent _copy() {
        ServiceUserAgent _x = new ServiceUserAgent();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.applicationVersion = applicationVersion;
        _x.headerValue = headerValue;
        _x.role = role;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServiceUserAgent[");
        b.append("applicationVersion=");
        b.append(this.applicationVersion);
        b.append(", ");
        b.append("headerValue=");
        b.append(this.headerValue);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
