package odata.msgraph.client.beta.callRecords.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Float;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.enums.MediaStreamDirection;

@JsonPropertyOrder({
    "@odata.type", 
    "averageAudioDegradation", 
    "averageAudioNetworkJitter", 
    "averageBandwidthEstimate", 
    "averageJitter", 
    "averagePacketLossRate", 
    "averageRatioOfConcealedSamples", 
    "averageReceivedFrameRate", 
    "averageRoundTripTime", 
    "averageVideoFrameLossPercentage", 
    "averageVideoFrameRate", 
    "averageVideoPacketLossRate", 
    "endDateTime", 
    "lowFrameRateRatio", 
    "lowVideoProcessingCapabilityRatio", 
    "maxAudioNetworkJitter", 
    "maxJitter", 
    "maxPacketLossRate", 
    "maxRatioOfConcealedSamples", 
    "maxRoundTripTime", 
    "packetUtilization", 
    "postForwardErrorCorrectionPacketLossRate", 
    "startDateTime", 
    "streamDirection", 
    "streamId", 
    "wasMediaBypassed"})
@JsonInclude(Include.NON_NULL)
public class MediaStream implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("averageAudioDegradation")
    protected Float averageAudioDegradation;

    @JsonProperty("averageAudioNetworkJitter")
    protected Duration averageAudioNetworkJitter;

    @JsonProperty("averageBandwidthEstimate")
    protected Long averageBandwidthEstimate;

    @JsonProperty("averageJitter")
    protected Duration averageJitter;

    @JsonProperty("averagePacketLossRate")
    protected Float averagePacketLossRate;

    @JsonProperty("averageRatioOfConcealedSamples")
    protected Float averageRatioOfConcealedSamples;

    @JsonProperty("averageReceivedFrameRate")
    protected Float averageReceivedFrameRate;

    @JsonProperty("averageRoundTripTime")
    protected Duration averageRoundTripTime;

    @JsonProperty("averageVideoFrameLossPercentage")
    protected Float averageVideoFrameLossPercentage;

    @JsonProperty("averageVideoFrameRate")
    protected Float averageVideoFrameRate;

    @JsonProperty("averageVideoPacketLossRate")
    protected Float averageVideoPacketLossRate;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("lowFrameRateRatio")
    protected Float lowFrameRateRatio;

    @JsonProperty("lowVideoProcessingCapabilityRatio")
    protected Float lowVideoProcessingCapabilityRatio;

    @JsonProperty("maxAudioNetworkJitter")
    protected Duration maxAudioNetworkJitter;

    @JsonProperty("maxJitter")
    protected Duration maxJitter;

    @JsonProperty("maxPacketLossRate")
    protected Float maxPacketLossRate;

    @JsonProperty("maxRatioOfConcealedSamples")
    protected Float maxRatioOfConcealedSamples;

    @JsonProperty("maxRoundTripTime")
    protected Duration maxRoundTripTime;

    @JsonProperty("packetUtilization")
    protected Long packetUtilization;

    @JsonProperty("postForwardErrorCorrectionPacketLossRate")
    protected Float postForwardErrorCorrectionPacketLossRate;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("streamDirection")
    protected MediaStreamDirection streamDirection;

    @JsonProperty("streamId")
    protected String streamId;

    @JsonProperty("wasMediaBypassed")
    protected Boolean wasMediaBypassed;

    protected MediaStream() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.callRecords.mediaStream";
    }

    @Property(name="averageAudioDegradation")
    @JsonIgnore
    public Optional<Float> getAverageAudioDegradation() {
        return Optional.ofNullable(averageAudioDegradation);
    }

    public MediaStream withAverageAudioDegradation(Float averageAudioDegradation) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageAudioDegradation = averageAudioDegradation;
        return _x;
    }

    @Property(name="averageAudioNetworkJitter")
    @JsonIgnore
    public Optional<Duration> getAverageAudioNetworkJitter() {
        return Optional.ofNullable(averageAudioNetworkJitter);
    }

    public MediaStream withAverageAudioNetworkJitter(Duration averageAudioNetworkJitter) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageAudioNetworkJitter = averageAudioNetworkJitter;
        return _x;
    }

    @Property(name="averageBandwidthEstimate")
    @JsonIgnore
    public Optional<Long> getAverageBandwidthEstimate() {
        return Optional.ofNullable(averageBandwidthEstimate);
    }

    public MediaStream withAverageBandwidthEstimate(Long averageBandwidthEstimate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageBandwidthEstimate = averageBandwidthEstimate;
        return _x;
    }

    @Property(name="averageJitter")
    @JsonIgnore
    public Optional<Duration> getAverageJitter() {
        return Optional.ofNullable(averageJitter);
    }

    public MediaStream withAverageJitter(Duration averageJitter) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageJitter = averageJitter;
        return _x;
    }

    @Property(name="averagePacketLossRate")
    @JsonIgnore
    public Optional<Float> getAveragePacketLossRate() {
        return Optional.ofNullable(averagePacketLossRate);
    }

    public MediaStream withAveragePacketLossRate(Float averagePacketLossRate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averagePacketLossRate = averagePacketLossRate;
        return _x;
    }

    @Property(name="averageRatioOfConcealedSamples")
    @JsonIgnore
    public Optional<Float> getAverageRatioOfConcealedSamples() {
        return Optional.ofNullable(averageRatioOfConcealedSamples);
    }

    public MediaStream withAverageRatioOfConcealedSamples(Float averageRatioOfConcealedSamples) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageRatioOfConcealedSamples = averageRatioOfConcealedSamples;
        return _x;
    }

    @Property(name="averageReceivedFrameRate")
    @JsonIgnore
    public Optional<Float> getAverageReceivedFrameRate() {
        return Optional.ofNullable(averageReceivedFrameRate);
    }

    public MediaStream withAverageReceivedFrameRate(Float averageReceivedFrameRate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageReceivedFrameRate = averageReceivedFrameRate;
        return _x;
    }

    @Property(name="averageRoundTripTime")
    @JsonIgnore
    public Optional<Duration> getAverageRoundTripTime() {
        return Optional.ofNullable(averageRoundTripTime);
    }

    public MediaStream withAverageRoundTripTime(Duration averageRoundTripTime) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageRoundTripTime = averageRoundTripTime;
        return _x;
    }

    @Property(name="averageVideoFrameLossPercentage")
    @JsonIgnore
    public Optional<Float> getAverageVideoFrameLossPercentage() {
        return Optional.ofNullable(averageVideoFrameLossPercentage);
    }

    public MediaStream withAverageVideoFrameLossPercentage(Float averageVideoFrameLossPercentage) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageVideoFrameLossPercentage = averageVideoFrameLossPercentage;
        return _x;
    }

    @Property(name="averageVideoFrameRate")
    @JsonIgnore
    public Optional<Float> getAverageVideoFrameRate() {
        return Optional.ofNullable(averageVideoFrameRate);
    }

    public MediaStream withAverageVideoFrameRate(Float averageVideoFrameRate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageVideoFrameRate = averageVideoFrameRate;
        return _x;
    }

    @Property(name="averageVideoPacketLossRate")
    @JsonIgnore
    public Optional<Float> getAverageVideoPacketLossRate() {
        return Optional.ofNullable(averageVideoPacketLossRate);
    }

    public MediaStream withAverageVideoPacketLossRate(Float averageVideoPacketLossRate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.averageVideoPacketLossRate = averageVideoPacketLossRate;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public MediaStream withEndDateTime(OffsetDateTime endDateTime) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="lowFrameRateRatio")
    @JsonIgnore
    public Optional<Float> getLowFrameRateRatio() {
        return Optional.ofNullable(lowFrameRateRatio);
    }

    public MediaStream withLowFrameRateRatio(Float lowFrameRateRatio) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.lowFrameRateRatio = lowFrameRateRatio;
        return _x;
    }

    @Property(name="lowVideoProcessingCapabilityRatio")
    @JsonIgnore
    public Optional<Float> getLowVideoProcessingCapabilityRatio() {
        return Optional.ofNullable(lowVideoProcessingCapabilityRatio);
    }

    public MediaStream withLowVideoProcessingCapabilityRatio(Float lowVideoProcessingCapabilityRatio) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.lowVideoProcessingCapabilityRatio = lowVideoProcessingCapabilityRatio;
        return _x;
    }

    @Property(name="maxAudioNetworkJitter")
    @JsonIgnore
    public Optional<Duration> getMaxAudioNetworkJitter() {
        return Optional.ofNullable(maxAudioNetworkJitter);
    }

    public MediaStream withMaxAudioNetworkJitter(Duration maxAudioNetworkJitter) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.maxAudioNetworkJitter = maxAudioNetworkJitter;
        return _x;
    }

    @Property(name="maxJitter")
    @JsonIgnore
    public Optional<Duration> getMaxJitter() {
        return Optional.ofNullable(maxJitter);
    }

    public MediaStream withMaxJitter(Duration maxJitter) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.maxJitter = maxJitter;
        return _x;
    }

    @Property(name="maxPacketLossRate")
    @JsonIgnore
    public Optional<Float> getMaxPacketLossRate() {
        return Optional.ofNullable(maxPacketLossRate);
    }

    public MediaStream withMaxPacketLossRate(Float maxPacketLossRate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.maxPacketLossRate = maxPacketLossRate;
        return _x;
    }

    @Property(name="maxRatioOfConcealedSamples")
    @JsonIgnore
    public Optional<Float> getMaxRatioOfConcealedSamples() {
        return Optional.ofNullable(maxRatioOfConcealedSamples);
    }

    public MediaStream withMaxRatioOfConcealedSamples(Float maxRatioOfConcealedSamples) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.maxRatioOfConcealedSamples = maxRatioOfConcealedSamples;
        return _x;
    }

    @Property(name="maxRoundTripTime")
    @JsonIgnore
    public Optional<Duration> getMaxRoundTripTime() {
        return Optional.ofNullable(maxRoundTripTime);
    }

    public MediaStream withMaxRoundTripTime(Duration maxRoundTripTime) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.maxRoundTripTime = maxRoundTripTime;
        return _x;
    }

    @Property(name="packetUtilization")
    @JsonIgnore
    public Optional<Long> getPacketUtilization() {
        return Optional.ofNullable(packetUtilization);
    }

    public MediaStream withPacketUtilization(Long packetUtilization) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.packetUtilization = packetUtilization;
        return _x;
    }

    @Property(name="postForwardErrorCorrectionPacketLossRate")
    @JsonIgnore
    public Optional<Float> getPostForwardErrorCorrectionPacketLossRate() {
        return Optional.ofNullable(postForwardErrorCorrectionPacketLossRate);
    }

    public MediaStream withPostForwardErrorCorrectionPacketLossRate(Float postForwardErrorCorrectionPacketLossRate) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.postForwardErrorCorrectionPacketLossRate = postForwardErrorCorrectionPacketLossRate;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public MediaStream withStartDateTime(OffsetDateTime startDateTime) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="streamDirection")
    @JsonIgnore
    public Optional<MediaStreamDirection> getStreamDirection() {
        return Optional.ofNullable(streamDirection);
    }

    public MediaStream withStreamDirection(MediaStreamDirection streamDirection) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.streamDirection = streamDirection;
        return _x;
    }

    @Property(name="streamId")
    @JsonIgnore
    public Optional<String> getStreamId() {
        return Optional.ofNullable(streamId);
    }

    public MediaStream withStreamId(String streamId) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.streamId = streamId;
        return _x;
    }

    @Property(name="wasMediaBypassed")
    @JsonIgnore
    public Optional<Boolean> getWasMediaBypassed() {
        return Optional.ofNullable(wasMediaBypassed);
    }

    public MediaStream withWasMediaBypassed(Boolean wasMediaBypassed) {
        MediaStream _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.callRecords.mediaStream");
        _x.wasMediaBypassed = wasMediaBypassed;
        return _x;
    }

    public MediaStream withUnmappedField(String name, Object value) {
        MediaStream _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Float averageAudioDegradation;
        private Duration averageAudioNetworkJitter;
        private Long averageBandwidthEstimate;
        private Duration averageJitter;
        private Float averagePacketLossRate;
        private Float averageRatioOfConcealedSamples;
        private Float averageReceivedFrameRate;
        private Duration averageRoundTripTime;
        private Float averageVideoFrameLossPercentage;
        private Float averageVideoFrameRate;
        private Float averageVideoPacketLossRate;
        private OffsetDateTime endDateTime;
        private Float lowFrameRateRatio;
        private Float lowVideoProcessingCapabilityRatio;
        private Duration maxAudioNetworkJitter;
        private Duration maxJitter;
        private Float maxPacketLossRate;
        private Float maxRatioOfConcealedSamples;
        private Duration maxRoundTripTime;
        private Long packetUtilization;
        private Float postForwardErrorCorrectionPacketLossRate;
        private OffsetDateTime startDateTime;
        private MediaStreamDirection streamDirection;
        private String streamId;
        private Boolean wasMediaBypassed;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder averageAudioDegradation(Float averageAudioDegradation) {
            this.averageAudioDegradation = averageAudioDegradation;
            this.changedFields = changedFields.add("averageAudioDegradation");
            return this;
        }

        public Builder averageAudioNetworkJitter(Duration averageAudioNetworkJitter) {
            this.averageAudioNetworkJitter = averageAudioNetworkJitter;
            this.changedFields = changedFields.add("averageAudioNetworkJitter");
            return this;
        }

        public Builder averageBandwidthEstimate(Long averageBandwidthEstimate) {
            this.averageBandwidthEstimate = averageBandwidthEstimate;
            this.changedFields = changedFields.add("averageBandwidthEstimate");
            return this;
        }

        public Builder averageJitter(Duration averageJitter) {
            this.averageJitter = averageJitter;
            this.changedFields = changedFields.add("averageJitter");
            return this;
        }

        public Builder averagePacketLossRate(Float averagePacketLossRate) {
            this.averagePacketLossRate = averagePacketLossRate;
            this.changedFields = changedFields.add("averagePacketLossRate");
            return this;
        }

        public Builder averageRatioOfConcealedSamples(Float averageRatioOfConcealedSamples) {
            this.averageRatioOfConcealedSamples = averageRatioOfConcealedSamples;
            this.changedFields = changedFields.add("averageRatioOfConcealedSamples");
            return this;
        }

        public Builder averageReceivedFrameRate(Float averageReceivedFrameRate) {
            this.averageReceivedFrameRate = averageReceivedFrameRate;
            this.changedFields = changedFields.add("averageReceivedFrameRate");
            return this;
        }

        public Builder averageRoundTripTime(Duration averageRoundTripTime) {
            this.averageRoundTripTime = averageRoundTripTime;
            this.changedFields = changedFields.add("averageRoundTripTime");
            return this;
        }

        public Builder averageVideoFrameLossPercentage(Float averageVideoFrameLossPercentage) {
            this.averageVideoFrameLossPercentage = averageVideoFrameLossPercentage;
            this.changedFields = changedFields.add("averageVideoFrameLossPercentage");
            return this;
        }

        public Builder averageVideoFrameRate(Float averageVideoFrameRate) {
            this.averageVideoFrameRate = averageVideoFrameRate;
            this.changedFields = changedFields.add("averageVideoFrameRate");
            return this;
        }

        public Builder averageVideoPacketLossRate(Float averageVideoPacketLossRate) {
            this.averageVideoPacketLossRate = averageVideoPacketLossRate;
            this.changedFields = changedFields.add("averageVideoPacketLossRate");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder lowFrameRateRatio(Float lowFrameRateRatio) {
            this.lowFrameRateRatio = lowFrameRateRatio;
            this.changedFields = changedFields.add("lowFrameRateRatio");
            return this;
        }

        public Builder lowVideoProcessingCapabilityRatio(Float lowVideoProcessingCapabilityRatio) {
            this.lowVideoProcessingCapabilityRatio = lowVideoProcessingCapabilityRatio;
            this.changedFields = changedFields.add("lowVideoProcessingCapabilityRatio");
            return this;
        }

        public Builder maxAudioNetworkJitter(Duration maxAudioNetworkJitter) {
            this.maxAudioNetworkJitter = maxAudioNetworkJitter;
            this.changedFields = changedFields.add("maxAudioNetworkJitter");
            return this;
        }

        public Builder maxJitter(Duration maxJitter) {
            this.maxJitter = maxJitter;
            this.changedFields = changedFields.add("maxJitter");
            return this;
        }

        public Builder maxPacketLossRate(Float maxPacketLossRate) {
            this.maxPacketLossRate = maxPacketLossRate;
            this.changedFields = changedFields.add("maxPacketLossRate");
            return this;
        }

        public Builder maxRatioOfConcealedSamples(Float maxRatioOfConcealedSamples) {
            this.maxRatioOfConcealedSamples = maxRatioOfConcealedSamples;
            this.changedFields = changedFields.add("maxRatioOfConcealedSamples");
            return this;
        }

        public Builder maxRoundTripTime(Duration maxRoundTripTime) {
            this.maxRoundTripTime = maxRoundTripTime;
            this.changedFields = changedFields.add("maxRoundTripTime");
            return this;
        }

        public Builder packetUtilization(Long packetUtilization) {
            this.packetUtilization = packetUtilization;
            this.changedFields = changedFields.add("packetUtilization");
            return this;
        }

        public Builder postForwardErrorCorrectionPacketLossRate(Float postForwardErrorCorrectionPacketLossRate) {
            this.postForwardErrorCorrectionPacketLossRate = postForwardErrorCorrectionPacketLossRate;
            this.changedFields = changedFields.add("postForwardErrorCorrectionPacketLossRate");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder streamDirection(MediaStreamDirection streamDirection) {
            this.streamDirection = streamDirection;
            this.changedFields = changedFields.add("streamDirection");
            return this;
        }

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            this.changedFields = changedFields.add("streamId");
            return this;
        }

        public Builder wasMediaBypassed(Boolean wasMediaBypassed) {
            this.wasMediaBypassed = wasMediaBypassed;
            this.changedFields = changedFields.add("wasMediaBypassed");
            return this;
        }

        public MediaStream build() {
            MediaStream _x = new MediaStream();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.callRecords.mediaStream";
            _x.averageAudioDegradation = averageAudioDegradation;
            _x.averageAudioNetworkJitter = averageAudioNetworkJitter;
            _x.averageBandwidthEstimate = averageBandwidthEstimate;
            _x.averageJitter = averageJitter;
            _x.averagePacketLossRate = averagePacketLossRate;
            _x.averageRatioOfConcealedSamples = averageRatioOfConcealedSamples;
            _x.averageReceivedFrameRate = averageReceivedFrameRate;
            _x.averageRoundTripTime = averageRoundTripTime;
            _x.averageVideoFrameLossPercentage = averageVideoFrameLossPercentage;
            _x.averageVideoFrameRate = averageVideoFrameRate;
            _x.averageVideoPacketLossRate = averageVideoPacketLossRate;
            _x.endDateTime = endDateTime;
            _x.lowFrameRateRatio = lowFrameRateRatio;
            _x.lowVideoProcessingCapabilityRatio = lowVideoProcessingCapabilityRatio;
            _x.maxAudioNetworkJitter = maxAudioNetworkJitter;
            _x.maxJitter = maxJitter;
            _x.maxPacketLossRate = maxPacketLossRate;
            _x.maxRatioOfConcealedSamples = maxRatioOfConcealedSamples;
            _x.maxRoundTripTime = maxRoundTripTime;
            _x.packetUtilization = packetUtilization;
            _x.postForwardErrorCorrectionPacketLossRate = postForwardErrorCorrectionPacketLossRate;
            _x.startDateTime = startDateTime;
            _x.streamDirection = streamDirection;
            _x.streamId = streamId;
            _x.wasMediaBypassed = wasMediaBypassed;
            return _x;
        }
    }

    private MediaStream _copy() {
        MediaStream _x = new MediaStream();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.averageAudioDegradation = averageAudioDegradation;
        _x.averageAudioNetworkJitter = averageAudioNetworkJitter;
        _x.averageBandwidthEstimate = averageBandwidthEstimate;
        _x.averageJitter = averageJitter;
        _x.averagePacketLossRate = averagePacketLossRate;
        _x.averageRatioOfConcealedSamples = averageRatioOfConcealedSamples;
        _x.averageReceivedFrameRate = averageReceivedFrameRate;
        _x.averageRoundTripTime = averageRoundTripTime;
        _x.averageVideoFrameLossPercentage = averageVideoFrameLossPercentage;
        _x.averageVideoFrameRate = averageVideoFrameRate;
        _x.averageVideoPacketLossRate = averageVideoPacketLossRate;
        _x.endDateTime = endDateTime;
        _x.lowFrameRateRatio = lowFrameRateRatio;
        _x.lowVideoProcessingCapabilityRatio = lowVideoProcessingCapabilityRatio;
        _x.maxAudioNetworkJitter = maxAudioNetworkJitter;
        _x.maxJitter = maxJitter;
        _x.maxPacketLossRate = maxPacketLossRate;
        _x.maxRatioOfConcealedSamples = maxRatioOfConcealedSamples;
        _x.maxRoundTripTime = maxRoundTripTime;
        _x.packetUtilization = packetUtilization;
        _x.postForwardErrorCorrectionPacketLossRate = postForwardErrorCorrectionPacketLossRate;
        _x.startDateTime = startDateTime;
        _x.streamDirection = streamDirection;
        _x.streamId = streamId;
        _x.wasMediaBypassed = wasMediaBypassed;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MediaStream[");
        b.append("averageAudioDegradation=");
        b.append(this.averageAudioDegradation);
        b.append(", ");
        b.append("averageAudioNetworkJitter=");
        b.append(this.averageAudioNetworkJitter);
        b.append(", ");
        b.append("averageBandwidthEstimate=");
        b.append(this.averageBandwidthEstimate);
        b.append(", ");
        b.append("averageJitter=");
        b.append(this.averageJitter);
        b.append(", ");
        b.append("averagePacketLossRate=");
        b.append(this.averagePacketLossRate);
        b.append(", ");
        b.append("averageRatioOfConcealedSamples=");
        b.append(this.averageRatioOfConcealedSamples);
        b.append(", ");
        b.append("averageReceivedFrameRate=");
        b.append(this.averageReceivedFrameRate);
        b.append(", ");
        b.append("averageRoundTripTime=");
        b.append(this.averageRoundTripTime);
        b.append(", ");
        b.append("averageVideoFrameLossPercentage=");
        b.append(this.averageVideoFrameLossPercentage);
        b.append(", ");
        b.append("averageVideoFrameRate=");
        b.append(this.averageVideoFrameRate);
        b.append(", ");
        b.append("averageVideoPacketLossRate=");
        b.append(this.averageVideoPacketLossRate);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("lowFrameRateRatio=");
        b.append(this.lowFrameRateRatio);
        b.append(", ");
        b.append("lowVideoProcessingCapabilityRatio=");
        b.append(this.lowVideoProcessingCapabilityRatio);
        b.append(", ");
        b.append("maxAudioNetworkJitter=");
        b.append(this.maxAudioNetworkJitter);
        b.append(", ");
        b.append("maxJitter=");
        b.append(this.maxJitter);
        b.append(", ");
        b.append("maxPacketLossRate=");
        b.append(this.maxPacketLossRate);
        b.append(", ");
        b.append("maxRatioOfConcealedSamples=");
        b.append(this.maxRatioOfConcealedSamples);
        b.append(", ");
        b.append("maxRoundTripTime=");
        b.append(this.maxRoundTripTime);
        b.append(", ");
        b.append("packetUtilization=");
        b.append(this.packetUtilization);
        b.append(", ");
        b.append("postForwardErrorCorrectionPacketLossRate=");
        b.append(this.postForwardErrorCorrectionPacketLossRate);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("streamDirection=");
        b.append(this.streamDirection);
        b.append(", ");
        b.append("streamId=");
        b.append(this.streamId);
        b.append(", ");
        b.append("wasMediaBypassed=");
        b.append(this.wasMediaBypassed);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
