package microsoft.graph.security.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ContentState implements Enum {

    @JsonProperty("rest")
    REST("rest", "0"),

    @JsonProperty("motion")
    MOTION("motion", "1"),

    @JsonProperty("use")
    USE("use", "2");

    private final String name;
    private final String value;

    private ContentState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
