package microsoft.graph.security.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.security.collection.request.SensitivityLabelCollectionRequest;
import microsoft.graph.security.entity.InformationProtection;

@JsonIgnoreType
public class InformationProtectionEntityRequest extends EntityRequest<InformationProtection> {

    public InformationProtectionEntityRequest(ContextPath contextPath, Optional<Object> value) {
        super(InformationProtection.class, contextPath, value, false);
    }

    public InformationProtectionPolicySettingEntityRequest labelPolicySettings() {
        return new InformationProtectionPolicySettingEntityRequest(contextPath.addSegment("labelPolicySettings"), Optional.empty());
    }

    public SensitivityLabelEntityRequest sensitivityLabels(String id) {
        return new SensitivityLabelEntityRequest(contextPath.addSegment("sensitivityLabels").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SensitivityLabelCollectionRequest sensitivityLabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sensitivityLabels"), Optional.empty());
    }

}
