package microsoft.graph.security.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.security.entity.request.SensitivityLabelEntityRequest;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "color", 
    "contentFormats", 
    "description", 
    "hasProtection", 
    "isActive", 
    "isAppliable", 
    "name", 
    "sensitivity", 
    "tooltip", 
    "parent"})
@JsonInclude(Include.NON_NULL)
public class SensitivityLabel extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.sensitivityLabel";
    }

    @JsonProperty("color")
    protected String color;

    @JsonProperty("contentFormats")
    protected List<String> contentFormats;

    @JsonProperty("contentFormats@nextLink")
    protected String contentFormatsNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("hasProtection")
    protected Boolean hasProtection;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("isAppliable")
    protected Boolean isAppliable;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("sensitivity")
    protected Integer sensitivity;

    @JsonProperty("tooltip")
    protected String tooltip;

    @JsonProperty("parent")
    protected SensitivityLabel parent;

    protected SensitivityLabel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSensitivityLabel() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String color;
        private List<String> contentFormats;
        private String contentFormatsNextLink;
        private String description;
        private Boolean hasProtection;
        private Boolean isActive;
        private Boolean isAppliable;
        private String name;
        private Integer sensitivity;
        private String tooltip;
        private SensitivityLabel parent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = changedFields.add("color");
            return this;
        }

        public Builder contentFormats(List<String> contentFormats) {
            this.contentFormats = contentFormats;
            this.changedFields = changedFields.add("contentFormats");
            return this;
        }

        public Builder contentFormats(String... contentFormats) {
            return contentFormats(Arrays.asList(contentFormats));
        }

        public Builder contentFormatsNextLink(String contentFormatsNextLink) {
            this.contentFormatsNextLink = contentFormatsNextLink;
            this.changedFields = changedFields.add("contentFormats");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder hasProtection(Boolean hasProtection) {
            this.hasProtection = hasProtection;
            this.changedFields = changedFields.add("hasProtection");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder isAppliable(Boolean isAppliable) {
            this.isAppliable = isAppliable;
            this.changedFields = changedFields.add("isAppliable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder sensitivity(Integer sensitivity) {
            this.sensitivity = sensitivity;
            this.changedFields = changedFields.add("sensitivity");
            return this;
        }

        public Builder tooltip(String tooltip) {
            this.tooltip = tooltip;
            this.changedFields = changedFields.add("tooltip");
            return this;
        }

        public Builder parent(SensitivityLabel parent) {
            this.parent = parent;
            this.changedFields = changedFields.add("parent");
            return this;
        }

        public SensitivityLabel build() {
            SensitivityLabel _x = new SensitivityLabel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.sensitivityLabel";
            _x.id = id;
            _x.color = color;
            _x.contentFormats = contentFormats;
            _x.contentFormatsNextLink = contentFormatsNextLink;
            _x.description = description;
            _x.hasProtection = hasProtection;
            _x.isActive = isActive;
            _x.isAppliable = isAppliable;
            _x.name = name;
            _x.sensitivity = sensitivity;
            _x.tooltip = tooltip;
            _x.parent = parent;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="color")
    @JsonIgnore
    public Optional<String> getColor() {
        return Optional.ofNullable(color);
    }

    public SensitivityLabel withColor(String color) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("color");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.color = color;
        return _x;
    }

    @Property(name="contentFormats")
    @JsonIgnore
    public CollectionPage<String> getContentFormats() {
        return new CollectionPage<String>(contextPath, String.class, this.contentFormats, Optional.ofNullable(contentFormatsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public SensitivityLabel withContentFormats(List<String> contentFormats) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("contentFormats");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.contentFormats = contentFormats;
        return _x;
    }

    @Property(name="contentFormats")
    @JsonIgnore
    public CollectionPage<String> getContentFormats(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.contentFormats, Optional.ofNullable(contentFormatsNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SensitivityLabel withDescription(String description) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.description = description;
        return _x;
    }

    @Property(name="hasProtection")
    @JsonIgnore
    public Optional<Boolean> getHasProtection() {
        return Optional.ofNullable(hasProtection);
    }

    public SensitivityLabel withHasProtection(Boolean hasProtection) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("hasProtection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.hasProtection = hasProtection;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public SensitivityLabel withIsActive(Boolean isActive) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("isActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="isAppliable")
    @JsonIgnore
    public Optional<Boolean> getIsAppliable() {
        return Optional.ofNullable(isAppliable);
    }

    public SensitivityLabel withIsAppliable(Boolean isAppliable) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("isAppliable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.isAppliable = isAppliable;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SensitivityLabel withName(String name) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.name = name;
        return _x;
    }

    @Property(name="sensitivity")
    @JsonIgnore
    public Optional<Integer> getSensitivity() {
        return Optional.ofNullable(sensitivity);
    }

    public SensitivityLabel withSensitivity(Integer sensitivity) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("sensitivity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.sensitivity = sensitivity;
        return _x;
    }

    @Property(name="tooltip")
    @JsonIgnore
    public Optional<String> getTooltip() {
        return Optional.ofNullable(tooltip);
    }

    public SensitivityLabel withTooltip(String tooltip) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("tooltip");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.tooltip = tooltip;
        return _x;
    }

    public SensitivityLabel withUnmappedField(String name, Object value) {
        SensitivityLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="parent")
    @JsonIgnore
    public SensitivityLabelEntityRequest getParent() {
        return new SensitivityLabelEntityRequest(contextPath.addSegment("parent"), Optional.ofNullable(parent));
    }

    public SensitivityLabel withParent(SensitivityLabel parent) {
        SensitivityLabel _x = _copy();
        _x.changedFields = changedFields.add("parent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.sensitivityLabel");
        _x.parent = parent;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitivityLabel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SensitivityLabel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitivityLabel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SensitivityLabel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SensitivityLabel _copy() {
        SensitivityLabel _x = new SensitivityLabel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.color = color;
        _x.contentFormats = contentFormats;
        _x.description = description;
        _x.hasProtection = hasProtection;
        _x.isActive = isActive;
        _x.isAppliable = isAppliable;
        _x.name = name;
        _x.sensitivity = sensitivity;
        _x.tooltip = tooltip;
        _x.parent = parent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SensitivityLabel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("color=");
        b.append(this.color);
        b.append(", ");
        b.append("contentFormats=");
        b.append(this.contentFormats);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("hasProtection=");
        b.append(this.hasProtection);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("isAppliable=");
        b.append(this.isAppliable);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("sensitivity=");
        b.append(this.sensitivity);
        b.append(", ");
        b.append("tooltip=");
        b.append(this.tooltip);
        b.append(", ");
        b.append("parent=");
        b.append(this.parent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
