package microsoft.graph.security.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultLabelId", 
    "isDowngradeJustificationRequired", 
    "isMandatory", 
    "moreInfoUrl"})
@JsonInclude(Include.NON_NULL)
public class InformationProtectionPolicySetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.informationProtectionPolicySetting";
    }

    @JsonProperty("defaultLabelId")
    protected String defaultLabelId;

    @JsonProperty("isDowngradeJustificationRequired")
    protected Boolean isDowngradeJustificationRequired;

    @JsonProperty("isMandatory")
    protected Boolean isMandatory;

    @JsonProperty("moreInfoUrl")
    protected String moreInfoUrl;

    protected InformationProtectionPolicySetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInformationProtectionPolicySetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String defaultLabelId;
        private Boolean isDowngradeJustificationRequired;
        private Boolean isMandatory;
        private String moreInfoUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder defaultLabelId(String defaultLabelId) {
            this.defaultLabelId = defaultLabelId;
            this.changedFields = changedFields.add("defaultLabelId");
            return this;
        }

        public Builder isDowngradeJustificationRequired(Boolean isDowngradeJustificationRequired) {
            this.isDowngradeJustificationRequired = isDowngradeJustificationRequired;
            this.changedFields = changedFields.add("isDowngradeJustificationRequired");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.changedFields = changedFields.add("isMandatory");
            return this;
        }

        public Builder moreInfoUrl(String moreInfoUrl) {
            this.moreInfoUrl = moreInfoUrl;
            this.changedFields = changedFields.add("moreInfoUrl");
            return this;
        }

        public InformationProtectionPolicySetting build() {
            InformationProtectionPolicySetting _x = new InformationProtectionPolicySetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.informationProtectionPolicySetting";
            _x.id = id;
            _x.defaultLabelId = defaultLabelId;
            _x.isDowngradeJustificationRequired = isDowngradeJustificationRequired;
            _x.isMandatory = isMandatory;
            _x.moreInfoUrl = moreInfoUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="defaultLabelId")
    @JsonIgnore
    public Optional<String> getDefaultLabelId() {
        return Optional.ofNullable(defaultLabelId);
    }

    public InformationProtectionPolicySetting withDefaultLabelId(String defaultLabelId) {
        InformationProtectionPolicySetting _x = _copy();
        _x.changedFields = changedFields.add("defaultLabelId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.informationProtectionPolicySetting");
        _x.defaultLabelId = defaultLabelId;
        return _x;
    }

    @Property(name="isDowngradeJustificationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsDowngradeJustificationRequired() {
        return Optional.ofNullable(isDowngradeJustificationRequired);
    }

    public InformationProtectionPolicySetting withIsDowngradeJustificationRequired(Boolean isDowngradeJustificationRequired) {
        InformationProtectionPolicySetting _x = _copy();
        _x.changedFields = changedFields.add("isDowngradeJustificationRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.informationProtectionPolicySetting");
        _x.isDowngradeJustificationRequired = isDowngradeJustificationRequired;
        return _x;
    }

    @Property(name="isMandatory")
    @JsonIgnore
    public Optional<Boolean> getIsMandatory() {
        return Optional.ofNullable(isMandatory);
    }

    public InformationProtectionPolicySetting withIsMandatory(Boolean isMandatory) {
        InformationProtectionPolicySetting _x = _copy();
        _x.changedFields = changedFields.add("isMandatory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.informationProtectionPolicySetting");
        _x.isMandatory = isMandatory;
        return _x;
    }

    @Property(name="moreInfoUrl")
    @JsonIgnore
    public Optional<String> getMoreInfoUrl() {
        return Optional.ofNullable(moreInfoUrl);
    }

    public InformationProtectionPolicySetting withMoreInfoUrl(String moreInfoUrl) {
        InformationProtectionPolicySetting _x = _copy();
        _x.changedFields = changedFields.add("moreInfoUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.informationProtectionPolicySetting");
        _x.moreInfoUrl = moreInfoUrl;
        return _x;
    }

    public InformationProtectionPolicySetting withUnmappedField(String name, Object value) {
        InformationProtectionPolicySetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InformationProtectionPolicySetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        InformationProtectionPolicySetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public InformationProtectionPolicySetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        InformationProtectionPolicySetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private InformationProtectionPolicySetting _copy() {
        InformationProtectionPolicySetting _x = new InformationProtectionPolicySetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.defaultLabelId = defaultLabelId;
        _x.isDowngradeJustificationRequired = isDowngradeJustificationRequired;
        _x.isMandatory = isMandatory;
        _x.moreInfoUrl = moreInfoUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InformationProtectionPolicySetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("defaultLabelId=");
        b.append(this.defaultLabelId);
        b.append(", ");
        b.append("isDowngradeJustificationRequired=");
        b.append(this.isDowngradeJustificationRequired);
        b.append(", ");
        b.append("isMandatory=");
        b.append(this.isMandatory);
        b.append(", ");
        b.append("moreInfoUrl=");
        b.append(this.moreInfoUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
