package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.security.enums.ActionSource;

@JsonPropertyOrder({
    "@odata.type", 
    "actions", 
    "actionSource", 
    "responsibleSensitiveTypeIds", 
    "sensitivityLabelId"})
@JsonInclude(Include.NON_NULL)
public class RecommendLabelAction extends InformationProtectionAction implements ODataType {

    @JsonProperty("actions")
    protected List<InformationProtectionAction> actions;

    @JsonProperty("actions@nextLink")
    protected String actionsNextLink;

    @JsonProperty("actionSource")
    protected ActionSource actionSource;

    @JsonProperty("responsibleSensitiveTypeIds")
    protected List<String> responsibleSensitiveTypeIds;

    @JsonProperty("responsibleSensitiveTypeIds@nextLink")
    protected String responsibleSensitiveTypeIdsNextLink;

    @JsonProperty("sensitivityLabelId")
    protected String sensitivityLabelId;

    protected RecommendLabelAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.recommendLabelAction";
    }

    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<InformationProtectionAction> getActions() {
        return new CollectionPage<InformationProtectionAction>(contextPath, InformationProtectionAction.class, this.actions, Optional.ofNullable(actionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="actions")
    @JsonIgnore
    public CollectionPage<InformationProtectionAction> getActions(HttpRequestOptions options) {
        return new CollectionPage<InformationProtectionAction>(contextPath, InformationProtectionAction.class, this.actions, Optional.ofNullable(actionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="actionSource")
    @JsonIgnore
    public Optional<ActionSource> getActionSource() {
        return Optional.ofNullable(actionSource);
    }

    public RecommendLabelAction withActionSource(ActionSource actionSource) {
        RecommendLabelAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.recommendLabelAction");
        _x.actionSource = actionSource;
        return _x;
    }

    @Property(name="responsibleSensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getResponsibleSensitiveTypeIds() {
        return new CollectionPage<String>(contextPath, String.class, this.responsibleSensitiveTypeIds, Optional.ofNullable(responsibleSensitiveTypeIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="responsibleSensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getResponsibleSensitiveTypeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.responsibleSensitiveTypeIds, Optional.ofNullable(responsibleSensitiveTypeIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="sensitivityLabelId")
    @JsonIgnore
    public Optional<String> getSensitivityLabelId() {
        return Optional.ofNullable(sensitivityLabelId);
    }

    public RecommendLabelAction withSensitivityLabelId(String sensitivityLabelId) {
        RecommendLabelAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.recommendLabelAction");
        _x.sensitivityLabelId = sensitivityLabelId;
        return _x;
    }

    public RecommendLabelAction withUnmappedField(String name, Object value) {
        RecommendLabelAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecommendLabelAction() {
        return new Builder();
    }

    public static final class Builder {
        private List<InformationProtectionAction> actions;
        private String actionsNextLink;
        private ActionSource actionSource;
        private List<String> responsibleSensitiveTypeIds;
        private String responsibleSensitiveTypeIdsNextLink;
        private String sensitivityLabelId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder actions(List<InformationProtectionAction> actions) {
            this.actions = actions;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder actions(InformationProtectionAction... actions) {
            return actions(Arrays.asList(actions));
        }

        public Builder actionsNextLink(String actionsNextLink) {
            this.actionsNextLink = actionsNextLink;
            this.changedFields = changedFields.add("actions");
            return this;
        }

        public Builder actionSource(ActionSource actionSource) {
            this.actionSource = actionSource;
            this.changedFields = changedFields.add("actionSource");
            return this;
        }

        public Builder responsibleSensitiveTypeIds(List<String> responsibleSensitiveTypeIds) {
            this.responsibleSensitiveTypeIds = responsibleSensitiveTypeIds;
            this.changedFields = changedFields.add("responsibleSensitiveTypeIds");
            return this;
        }

        public Builder responsibleSensitiveTypeIds(String... responsibleSensitiveTypeIds) {
            return responsibleSensitiveTypeIds(Arrays.asList(responsibleSensitiveTypeIds));
        }

        public Builder responsibleSensitiveTypeIdsNextLink(String responsibleSensitiveTypeIdsNextLink) {
            this.responsibleSensitiveTypeIdsNextLink = responsibleSensitiveTypeIdsNextLink;
            this.changedFields = changedFields.add("responsibleSensitiveTypeIds");
            return this;
        }

        public Builder sensitivityLabelId(String sensitivityLabelId) {
            this.sensitivityLabelId = sensitivityLabelId;
            this.changedFields = changedFields.add("sensitivityLabelId");
            return this;
        }

        public RecommendLabelAction build() {
            RecommendLabelAction _x = new RecommendLabelAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.recommendLabelAction";
            _x.actions = actions;
            _x.actionsNextLink = actionsNextLink;
            _x.actionSource = actionSource;
            _x.responsibleSensitiveTypeIds = responsibleSensitiveTypeIds;
            _x.responsibleSensitiveTypeIdsNextLink = responsibleSensitiveTypeIdsNextLink;
            _x.sensitivityLabelId = sensitivityLabelId;
            return _x;
        }
    }

    private RecommendLabelAction _copy() {
        RecommendLabelAction _x = new RecommendLabelAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.actions = actions;
        _x.actionSource = actionSource;
        _x.responsibleSensitiveTypeIds = responsibleSensitiveTypeIds;
        _x.sensitivityLabelId = sensitivityLabelId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RecommendLabelAction[");
        b.append("actions=");
        b.append(this.actions);
        b.append(", ");
        b.append("actionSource=");
        b.append(this.actionSource);
        b.append(", ");
        b.append("responsibleSensitiveTypeIds=");
        b.append(this.responsibleSensitiveTypeIds);
        b.append(", ");
        b.append("sensitivityLabelId=");
        b.append(this.sensitivityLabelId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
