package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "metadataToAdd", 
    "metadataToRemove"})
@JsonInclude(Include.NON_NULL)
public class MetadataAction extends InformationProtectionAction implements ODataType {

    @JsonProperty("metadataToAdd")
    protected List<KeyValuePair> metadataToAdd;

    @JsonProperty("metadataToAdd@nextLink")
    protected String metadataToAddNextLink;

    @JsonProperty("metadataToRemove")
    protected List<String> metadataToRemove;

    @JsonProperty("metadataToRemove@nextLink")
    protected String metadataToRemoveNextLink;

    protected MetadataAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.metadataAction";
    }

    @Property(name="metadataToAdd")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMetadataToAdd() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.metadataToAdd, Optional.ofNullable(metadataToAddNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadataToAdd")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMetadataToAdd(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.metadataToAdd, Optional.ofNullable(metadataToAddNextLink), Collections.emptyList(), options);
    }

    @Property(name="metadataToRemove")
    @JsonIgnore
    public CollectionPage<String> getMetadataToRemove() {
        return new CollectionPage<String>(contextPath, String.class, this.metadataToRemove, Optional.ofNullable(metadataToRemoveNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadataToRemove")
    @JsonIgnore
    public CollectionPage<String> getMetadataToRemove(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.metadataToRemove, Optional.ofNullable(metadataToRemoveNextLink), Collections.emptyList(), options);
    }

    public MetadataAction withUnmappedField(String name, Object value) {
        MetadataAction _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMetadataAction() {
        return new Builder();
    }

    public static final class Builder {
        private List<KeyValuePair> metadataToAdd;
        private String metadataToAddNextLink;
        private List<String> metadataToRemove;
        private String metadataToRemoveNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataToAdd(List<KeyValuePair> metadataToAdd) {
            this.metadataToAdd = metadataToAdd;
            this.changedFields = changedFields.add("metadataToAdd");
            return this;
        }

        public Builder metadataToAdd(KeyValuePair... metadataToAdd) {
            return metadataToAdd(Arrays.asList(metadataToAdd));
        }

        public Builder metadataToAddNextLink(String metadataToAddNextLink) {
            this.metadataToAddNextLink = metadataToAddNextLink;
            this.changedFields = changedFields.add("metadataToAdd");
            return this;
        }

        public Builder metadataToRemove(List<String> metadataToRemove) {
            this.metadataToRemove = metadataToRemove;
            this.changedFields = changedFields.add("metadataToRemove");
            return this;
        }

        public Builder metadataToRemove(String... metadataToRemove) {
            return metadataToRemove(Arrays.asList(metadataToRemove));
        }

        public Builder metadataToRemoveNextLink(String metadataToRemoveNextLink) {
            this.metadataToRemoveNextLink = metadataToRemoveNextLink;
            this.changedFields = changedFields.add("metadataToRemove");
            return this;
        }

        public MetadataAction build() {
            MetadataAction _x = new MetadataAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.metadataAction";
            _x.metadataToAdd = metadataToAdd;
            _x.metadataToAddNextLink = metadataToAddNextLink;
            _x.metadataToRemove = metadataToRemove;
            _x.metadataToRemoveNextLink = metadataToRemoveNextLink;
            return _x;
        }
    }

    private MetadataAction _copy() {
        MetadataAction _x = new MetadataAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataToAdd = metadataToAdd;
        _x.metadataToRemove = metadataToRemove;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataAction[");
        b.append("metadataToAdd=");
        b.append(this.metadataToAdd);
        b.append(", ");
        b.append("metadataToRemove=");
        b.append(this.metadataToRemove);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
