package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.graph.security.enums.AssignmentMethod;

@JsonPropertyOrder({
    "@odata.type", 
    "assignmentMethod", 
    "createdDateTime", 
    "sensitivityLabelId"})
@JsonInclude(Include.NON_NULL)
public class ContentLabel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("assignmentMethod")
    protected AssignmentMethod assignmentMethod;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("sensitivityLabelId")
    protected String sensitivityLabelId;

    protected ContentLabel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.contentLabel";
    }

    @Property(name="assignmentMethod")
    @JsonIgnore
    public Optional<AssignmentMethod> getAssignmentMethod() {
        return Optional.ofNullable(assignmentMethod);
    }

    public ContentLabel withAssignmentMethod(AssignmentMethod assignmentMethod) {
        ContentLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.contentLabel");
        _x.assignmentMethod = assignmentMethod;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ContentLabel withCreatedDateTime(OffsetDateTime createdDateTime) {
        ContentLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.contentLabel");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="sensitivityLabelId")
    @JsonIgnore
    public Optional<String> getSensitivityLabelId() {
        return Optional.ofNullable(sensitivityLabelId);
    }

    public ContentLabel withSensitivityLabelId(String sensitivityLabelId) {
        ContentLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.contentLabel");
        _x.sensitivityLabelId = sensitivityLabelId;
        return _x;
    }

    public ContentLabel withUnmappedField(String name, Object value) {
        ContentLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AssignmentMethod assignmentMethod;
        private OffsetDateTime createdDateTime;
        private String sensitivityLabelId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder assignmentMethod(AssignmentMethod assignmentMethod) {
            this.assignmentMethod = assignmentMethod;
            this.changedFields = changedFields.add("assignmentMethod");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder sensitivityLabelId(String sensitivityLabelId) {
            this.sensitivityLabelId = sensitivityLabelId;
            this.changedFields = changedFields.add("sensitivityLabelId");
            return this;
        }

        public ContentLabel build() {
            ContentLabel _x = new ContentLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.contentLabel";
            _x.assignmentMethod = assignmentMethod;
            _x.createdDateTime = createdDateTime;
            _x.sensitivityLabelId = sensitivityLabelId;
            return _x;
        }
    }

    private ContentLabel _copy() {
        ContentLabel _x = new ContentLabel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.assignmentMethod = assignmentMethod;
        _x.createdDateTime = createdDateTime;
        _x.sensitivityLabelId = sensitivityLabelId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentLabel[");
        b.append("assignmentMethod=");
        b.append(this.assignmentMethod);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("sensitivityLabelId=");
        b.append(this.sensitivityLabelId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
