package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.security.enums.ContentState;

@JsonPropertyOrder({
    "@odata.type", 
    "contentFormat", 
    "identifier", 
    "metadata", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class ContentInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("contentFormat")
    protected String contentFormat;

    @JsonProperty("identifier")
    protected String identifier;

    @JsonProperty("metadata")
    protected List<KeyValuePair> metadata;

    @JsonProperty("metadata@nextLink")
    protected String metadataNextLink;

    @JsonProperty("state")
    protected ContentState state;

    protected ContentInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.contentInfo";
    }

    @Property(name="contentFormat")
    @JsonIgnore
    public Optional<String> getContentFormat() {
        return Optional.ofNullable(contentFormat);
    }

    public ContentInfo withContentFormat(String contentFormat) {
        ContentInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.contentInfo");
        _x.contentFormat = contentFormat;
        return _x;
    }

    @Property(name="identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public ContentInfo withIdentifier(String identifier) {
        ContentInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.contentInfo");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMetadata() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.metadata, Optional.ofNullable(metadataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.metadata, Optional.ofNullable(metadataNextLink), Collections.emptyList(), options);
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<ContentState> getState() {
        return Optional.ofNullable(state);
    }

    public ContentInfo withState(ContentState state) {
        ContentInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.contentInfo");
        _x.state = state;
        return _x;
    }

    public ContentInfo withUnmappedField(String name, Object value) {
        ContentInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String contentFormat;
        private String identifier;
        private List<KeyValuePair> metadata;
        private String metadataNextLink;
        private ContentState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder contentFormat(String contentFormat) {
            this.contentFormat = contentFormat;
            this.changedFields = changedFields.add("contentFormat");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("identifier");
            return this;
        }

        public Builder metadata(List<KeyValuePair> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder metadata(KeyValuePair... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder state(ContentState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public ContentInfo build() {
            ContentInfo _x = new ContentInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.contentInfo";
            _x.contentFormat = contentFormat;
            _x.identifier = identifier;
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            _x.state = state;
            return _x;
        }
    }

    private ContentInfo _copy() {
        ContentInfo _x = new ContentInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.contentFormat = contentFormat;
        _x.identifier = identifier;
        _x.metadata = metadata;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentInfo[");
        b.append("contentFormat=");
        b.append(this.contentFormat);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
