package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "confidenceLevel", 
    "count", 
    "sensitiveTypeId"})
@JsonInclude(Include.NON_NULL)
public class ClassificationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("confidenceLevel")
    protected Integer confidenceLevel;

    @JsonProperty("count")
    protected Integer count;

    @JsonProperty("sensitiveTypeId")
    protected String sensitiveTypeId;

    protected ClassificationResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.classificationResult";
    }

    @Property(name="confidenceLevel")
    @JsonIgnore
    public Optional<Integer> getConfidenceLevel() {
        return Optional.ofNullable(confidenceLevel);
    }

    public ClassificationResult withConfidenceLevel(Integer confidenceLevel) {
        ClassificationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.classificationResult");
        _x.confidenceLevel = confidenceLevel;
        return _x;
    }

    @Property(name="count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public ClassificationResult withCount(Integer count) {
        ClassificationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.classificationResult");
        _x.count = count;
        return _x;
    }

    @Property(name="sensitiveTypeId")
    @JsonIgnore
    public Optional<String> getSensitiveTypeId() {
        return Optional.ofNullable(sensitiveTypeId);
    }

    public ClassificationResult withSensitiveTypeId(String sensitiveTypeId) {
        ClassificationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.classificationResult");
        _x.sensitiveTypeId = sensitiveTypeId;
        return _x;
    }

    public ClassificationResult withUnmappedField(String name, Object value) {
        ClassificationResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer confidenceLevel;
        private Integer count;
        private String sensitiveTypeId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder confidenceLevel(Integer confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
            this.changedFields = changedFields.add("confidenceLevel");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("count");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.changedFields = changedFields.add("sensitiveTypeId");
            return this;
        }

        public ClassificationResult build() {
            ClassificationResult _x = new ClassificationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.classificationResult";
            _x.confidenceLevel = confidenceLevel;
            _x.count = count;
            _x.sensitiveTypeId = sensitiveTypeId;
            return _x;
        }
    }

    private ClassificationResult _copy() {
        ClassificationResult _x = new ClassificationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.confidenceLevel = confidenceLevel;
        _x.count = count;
        _x.sensitiveTypeId = sensitiveTypeId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ClassificationResult[");
        b.append("confidenceLevel=");
        b.append(this.confidenceLevel);
        b.append(", ");
        b.append("count=");
        b.append(this.count);
        b.append(", ");
        b.append("sensitiveTypeId=");
        b.append(this.sensitiveTypeId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
