package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "encryptedBuffer", 
    "publishingLicense"})
@JsonInclude(Include.NON_NULL)
public class BufferEncryptionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("encryptedBuffer")
    protected byte[] encryptedBuffer;

    @JsonProperty("publishingLicense")
    protected byte[] publishingLicense;

    protected BufferEncryptionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.bufferEncryptionResult";
    }

    @Property(name="encryptedBuffer")
    @JsonIgnore
    public Optional<byte[]> getEncryptedBuffer() {
        return Optional.ofNullable(encryptedBuffer);
    }

    public BufferEncryptionResult withEncryptedBuffer(byte[] encryptedBuffer) {
        BufferEncryptionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.bufferEncryptionResult");
        _x.encryptedBuffer = encryptedBuffer;
        return _x;
    }

    @Property(name="publishingLicense")
    @JsonIgnore
    public Optional<byte[]> getPublishingLicense() {
        return Optional.ofNullable(publishingLicense);
    }

    public BufferEncryptionResult withPublishingLicense(byte[] publishingLicense) {
        BufferEncryptionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.bufferEncryptionResult");
        _x.publishingLicense = publishingLicense;
        return _x;
    }

    public BufferEncryptionResult withUnmappedField(String name, Object value) {
        BufferEncryptionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] encryptedBuffer;
        private byte[] publishingLicense;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder encryptedBuffer(byte[] encryptedBuffer) {
            this.encryptedBuffer = encryptedBuffer;
            this.changedFields = changedFields.add("encryptedBuffer");
            return this;
        }

        public Builder publishingLicense(byte[] publishingLicense) {
            this.publishingLicense = publishingLicense;
            this.changedFields = changedFields.add("publishingLicense");
            return this;
        }

        public BufferEncryptionResult build() {
            BufferEncryptionResult _x = new BufferEncryptionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.bufferEncryptionResult";
            _x.encryptedBuffer = encryptedBuffer;
            _x.publishingLicense = publishingLicense;
            return _x;
        }
    }

    private BufferEncryptionResult _copy() {
        BufferEncryptionResult _x = new BufferEncryptionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.encryptedBuffer = encryptedBuffer;
        _x.publishingLicense = publishingLicense;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BufferEncryptionResult[");
        b.append("encryptedBuffer=");
        b.append(this.encryptedBuffer);
        b.append(", ");
        b.append("publishingLicense=");
        b.append(this.publishingLicense);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
