package microsoft.graph.security.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "decryptedBuffer"})
@JsonInclude(Include.NON_NULL)
public class BufferDecryptionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("decryptedBuffer")
    protected byte[] decryptedBuffer;

    protected BufferDecryptionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.security.bufferDecryptionResult";
    }

    @Property(name="decryptedBuffer")
    @JsonIgnore
    public Optional<byte[]> getDecryptedBuffer() {
        return Optional.ofNullable(decryptedBuffer);
    }

    public BufferDecryptionResult withDecryptedBuffer(byte[] decryptedBuffer) {
        BufferDecryptionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.security.bufferDecryptionResult");
        _x.decryptedBuffer = decryptedBuffer;
        return _x;
    }

    public BufferDecryptionResult withUnmappedField(String name, Object value) {
        BufferDecryptionResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] decryptedBuffer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder decryptedBuffer(byte[] decryptedBuffer) {
            this.decryptedBuffer = decryptedBuffer;
            this.changedFields = changedFields.add("decryptedBuffer");
            return this;
        }

        public BufferDecryptionResult build() {
            BufferDecryptionResult _x = new BufferDecryptionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.security.bufferDecryptionResult";
            _x.decryptedBuffer = decryptedBuffer;
            return _x;
        }
    }

    private BufferDecryptionResult _copy() {
        BufferDecryptionResult _x = new BufferDecryptionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.decryptedBuffer = decryptedBuffer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BufferDecryptionResult[");
        b.append("decryptedBuffer=");
        b.append(this.decryptedBuffer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
