package microsoft.graph.security.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import microsoft.graph.security.complex.ClassificationResult;
import microsoft.graph.security.complex.ContentInfo;
import microsoft.graph.security.complex.ContentLabel;
import microsoft.graph.security.complex.DowngradeJustification;
import microsoft.graph.security.complex.InformationProtectionAction;
import microsoft.graph.security.complex.LabelingOptions;
import microsoft.graph.security.entity.SensitivityLabel;
import microsoft.graph.security.entity.request.SensitivityLabelEntityRequest;

public class SensitivityLabelCollectionRequest extends CollectionPageEntityRequest<SensitivityLabel, SensitivityLabelEntityRequest>{

    protected ContextPath contextPath;

    public SensitivityLabelCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SensitivityLabel.class, cp -> new SensitivityLabelEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "evaluateApplication")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InformationProtectionAction> evaluateApplication(ContentInfo contentInfo, LabelingOptions labelingOptions) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Preconditions.checkNotNull(labelingOptions, "labelingOptions cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.security.contentInfo", contentInfo)
            .put("labelingOptions", "microsoft.graph.security.labelingOptions", labelingOptions)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.security.evaluateApplication"), InformationProtectionAction.class, _parameters);
    }

    @Action(name = "evaluateClassificationResults")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InformationProtectionAction> evaluateClassificationResults(ContentInfo contentInfo, List<ClassificationResult> classificationResults) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Preconditions.checkNotNull(classificationResults, "classificationResults cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.security.contentInfo", contentInfo)
            .put("classificationResults", "Collection(microsoft.graph.security.classificationResult)", classificationResults)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.security.evaluateClassificationResults"), InformationProtectionAction.class, _parameters);
    }

    @Action(name = "evaluateRemoval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<InformationProtectionAction> evaluateRemoval(ContentInfo contentInfo, DowngradeJustification downgradeJustification) {
        Preconditions.checkNotNull(contentInfo, "contentInfo cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.security.contentInfo", contentInfo)
            .put("downgradeJustification", "microsoft.graph.security.downgradeJustification", downgradeJustification)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.security.evaluateRemoval"), InformationProtectionAction.class, _parameters);
    }

    @Action(name = "extractContentLabel")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ContentLabel> extractContentLabel(ContentInfo contentInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("contentInfo", "microsoft.graph.security.contentInfo", contentInfo)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ContentLabel>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.security.extractContentLabel"), ContentLabel.class, _parameters);
    }

}
