package microsoft.graph.search.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.search.complex.AnswerKeyword;
import microsoft.graph.search.complex.AnswerVariant;
import microsoft.graph.search.complex.IdentitySet;
import microsoft.graph.search.enums.AnswerState;

import odata.msgraph.client.beta.enums.DevicePlatformType;

@JsonPropertyOrder({
    "@odata.type", 
    "availabilityEndDateTime", 
    "availabilityStartDateTime", 
    "categories", 
    "groupIds", 
    "isSuggested", 
    "keywords", 
    "languageTags", 
    "platforms", 
    "powerAppIds", 
    "state", 
    "targetedVariations"})
@JsonInclude(Include.NON_NULL)
public class Bookmark extends SearchAnswer implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.search.bookmark";
    }

    @JsonProperty("availabilityEndDateTime")
    protected OffsetDateTime availabilityEndDateTime;

    @JsonProperty("availabilityStartDateTime")
    protected OffsetDateTime availabilityStartDateTime;

    @JsonProperty("categories")
    protected List<String> categories;

    @JsonProperty("categories@nextLink")
    protected String categoriesNextLink;

    @JsonProperty("groupIds")
    protected List<String> groupIds;

    @JsonProperty("groupIds@nextLink")
    protected String groupIdsNextLink;

    @JsonProperty("isSuggested")
    protected Boolean isSuggested;

    @JsonProperty("keywords")
    protected AnswerKeyword keywords;

    @JsonProperty("languageTags")
    protected List<String> languageTags;

    @JsonProperty("languageTags@nextLink")
    protected String languageTagsNextLink;

    @JsonProperty("platforms")
    protected List<DevicePlatformType> platforms;

    @JsonProperty("platforms@nextLink")
    protected String platformsNextLink;

    @JsonProperty("powerAppIds")
    protected List<String> powerAppIds;

    @JsonProperty("powerAppIds@nextLink")
    protected String powerAppIdsNextLink;

    @JsonProperty("state")
    protected AnswerState state;

    @JsonProperty("targetedVariations")
    protected List<AnswerVariant> targetedVariations;

    @JsonProperty("targetedVariations@nextLink")
    protected String targetedVariationsNextLink;

    protected Bookmark() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookmark() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private IdentitySet lastModifiedBy;
        private OffsetDateTime lastModifiedDateTime;
        private String webUrl;
        private OffsetDateTime availabilityEndDateTime;
        private OffsetDateTime availabilityStartDateTime;
        private List<String> categories;
        private String categoriesNextLink;
        private List<String> groupIds;
        private String groupIdsNextLink;
        private Boolean isSuggested;
        private AnswerKeyword keywords;
        private List<String> languageTags;
        private String languageTagsNextLink;
        private List<DevicePlatformType> platforms;
        private String platformsNextLink;
        private List<String> powerAppIds;
        private String powerAppIdsNextLink;
        private AnswerState state;
        private List<AnswerVariant> targetedVariations;
        private String targetedVariationsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder availabilityEndDateTime(OffsetDateTime availabilityEndDateTime) {
            this.availabilityEndDateTime = availabilityEndDateTime;
            this.changedFields = changedFields.add("availabilityEndDateTime");
            return this;
        }

        public Builder availabilityStartDateTime(OffsetDateTime availabilityStartDateTime) {
            this.availabilityStartDateTime = availabilityStartDateTime;
            this.changedFields = changedFields.add("availabilityStartDateTime");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder groupIds(List<String> groupIds) {
            this.groupIds = groupIds;
            this.changedFields = changedFields.add("groupIds");
            return this;
        }

        public Builder groupIds(String... groupIds) {
            return groupIds(Arrays.asList(groupIds));
        }

        public Builder groupIdsNextLink(String groupIdsNextLink) {
            this.groupIdsNextLink = groupIdsNextLink;
            this.changedFields = changedFields.add("groupIds");
            return this;
        }

        public Builder isSuggested(Boolean isSuggested) {
            this.isSuggested = isSuggested;
            this.changedFields = changedFields.add("isSuggested");
            return this;
        }

        public Builder keywords(AnswerKeyword keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder languageTags(List<String> languageTags) {
            this.languageTags = languageTags;
            this.changedFields = changedFields.add("languageTags");
            return this;
        }

        public Builder languageTags(String... languageTags) {
            return languageTags(Arrays.asList(languageTags));
        }

        public Builder languageTagsNextLink(String languageTagsNextLink) {
            this.languageTagsNextLink = languageTagsNextLink;
            this.changedFields = changedFields.add("languageTags");
            return this;
        }

        public Builder platforms(List<DevicePlatformType> platforms) {
            this.platforms = platforms;
            this.changedFields = changedFields.add("platforms");
            return this;
        }

        public Builder platforms(DevicePlatformType... platforms) {
            return platforms(Arrays.asList(platforms));
        }

        public Builder platformsNextLink(String platformsNextLink) {
            this.platformsNextLink = platformsNextLink;
            this.changedFields = changedFields.add("platforms");
            return this;
        }

        public Builder powerAppIds(List<String> powerAppIds) {
            this.powerAppIds = powerAppIds;
            this.changedFields = changedFields.add("powerAppIds");
            return this;
        }

        public Builder powerAppIds(String... powerAppIds) {
            return powerAppIds(Arrays.asList(powerAppIds));
        }

        public Builder powerAppIdsNextLink(String powerAppIdsNextLink) {
            this.powerAppIdsNextLink = powerAppIdsNextLink;
            this.changedFields = changedFields.add("powerAppIds");
            return this;
        }

        public Builder state(AnswerState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder targetedVariations(List<AnswerVariant> targetedVariations) {
            this.targetedVariations = targetedVariations;
            this.changedFields = changedFields.add("targetedVariations");
            return this;
        }

        public Builder targetedVariations(AnswerVariant... targetedVariations) {
            return targetedVariations(Arrays.asList(targetedVariations));
        }

        public Builder targetedVariationsNextLink(String targetedVariationsNextLink) {
            this.targetedVariationsNextLink = targetedVariationsNextLink;
            this.changedFields = changedFields.add("targetedVariations");
            return this;
        }

        public Bookmark build() {
            Bookmark _x = new Bookmark();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.search.bookmark";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedBy = lastModifiedBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.webUrl = webUrl;
            _x.availabilityEndDateTime = availabilityEndDateTime;
            _x.availabilityStartDateTime = availabilityStartDateTime;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.groupIds = groupIds;
            _x.groupIdsNextLink = groupIdsNextLink;
            _x.isSuggested = isSuggested;
            _x.keywords = keywords;
            _x.languageTags = languageTags;
            _x.languageTagsNextLink = languageTagsNextLink;
            _x.platforms = platforms;
            _x.platformsNextLink = platformsNextLink;
            _x.powerAppIds = powerAppIds;
            _x.powerAppIdsNextLink = powerAppIdsNextLink;
            _x.state = state;
            _x.targetedVariations = targetedVariations;
            _x.targetedVariationsNextLink = targetedVariationsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="availabilityEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAvailabilityEndDateTime() {
        return Optional.ofNullable(availabilityEndDateTime);
    }

    public Bookmark withAvailabilityEndDateTime(OffsetDateTime availabilityEndDateTime) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("availabilityEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.availabilityEndDateTime = availabilityEndDateTime;
        return _x;
    }

    @Property(name="availabilityStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAvailabilityStartDateTime() {
        return Optional.ofNullable(availabilityStartDateTime);
    }

    public Bookmark withAvailabilityStartDateTime(OffsetDateTime availabilityStartDateTime) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("availabilityStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.availabilityStartDateTime = availabilityStartDateTime;
        return _x;
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories() {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Bookmark withCategories(List<String> categories) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.categories = categories;
        return _x;
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), options);
    }

    @Property(name="groupIds")
    @JsonIgnore
    public CollectionPage<String> getGroupIds() {
        return new CollectionPage<String>(contextPath, String.class, this.groupIds, Optional.ofNullable(groupIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Bookmark withGroupIds(List<String> groupIds) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("groupIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.groupIds = groupIds;
        return _x;
    }

    @Property(name="groupIds")
    @JsonIgnore
    public CollectionPage<String> getGroupIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.groupIds, Optional.ofNullable(groupIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isSuggested")
    @JsonIgnore
    public Optional<Boolean> getIsSuggested() {
        return Optional.ofNullable(isSuggested);
    }

    public Bookmark withIsSuggested(Boolean isSuggested) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("isSuggested");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.isSuggested = isSuggested;
        return _x;
    }

    @Property(name="keywords")
    @JsonIgnore
    public Optional<AnswerKeyword> getKeywords() {
        return Optional.ofNullable(keywords);
    }

    public Bookmark withKeywords(AnswerKeyword keywords) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("keywords");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.keywords = keywords;
        return _x;
    }

    @Property(name="languageTags")
    @JsonIgnore
    public CollectionPage<String> getLanguageTags() {
        return new CollectionPage<String>(contextPath, String.class, this.languageTags, Optional.ofNullable(languageTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Bookmark withLanguageTags(List<String> languageTags) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("languageTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.languageTags = languageTags;
        return _x;
    }

    @Property(name="languageTags")
    @JsonIgnore
    public CollectionPage<String> getLanguageTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.languageTags, Optional.ofNullable(languageTagsNextLink), Collections.emptyList(), options);
    }

    @Property(name="platforms")
    @JsonIgnore
    public CollectionPage<DevicePlatformType> getPlatforms() {
        return new CollectionPage<DevicePlatformType>(contextPath, DevicePlatformType.class, this.platforms, Optional.ofNullable(platformsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Bookmark withPlatforms(List<DevicePlatformType> platforms) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("platforms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.platforms = platforms;
        return _x;
    }

    @Property(name="platforms")
    @JsonIgnore
    public CollectionPage<DevicePlatformType> getPlatforms(HttpRequestOptions options) {
        return new CollectionPage<DevicePlatformType>(contextPath, DevicePlatformType.class, this.platforms, Optional.ofNullable(platformsNextLink), Collections.emptyList(), options);
    }

    @Property(name="powerAppIds")
    @JsonIgnore
    public CollectionPage<String> getPowerAppIds() {
        return new CollectionPage<String>(contextPath, String.class, this.powerAppIds, Optional.ofNullable(powerAppIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Bookmark withPowerAppIds(List<String> powerAppIds) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("powerAppIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.powerAppIds = powerAppIds;
        return _x;
    }

    @Property(name="powerAppIds")
    @JsonIgnore
    public CollectionPage<String> getPowerAppIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.powerAppIds, Optional.ofNullable(powerAppIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<AnswerState> getState() {
        return Optional.ofNullable(state);
    }

    public Bookmark withState(AnswerState state) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.state = state;
        return _x;
    }

    @Property(name="targetedVariations")
    @JsonIgnore
    public CollectionPage<AnswerVariant> getTargetedVariations() {
        return new CollectionPage<AnswerVariant>(contextPath, AnswerVariant.class, this.targetedVariations, Optional.ofNullable(targetedVariationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Bookmark withTargetedVariations(List<AnswerVariant> targetedVariations) {
        Bookmark _x = _copy();
        _x.changedFields = changedFields.add("targetedVariations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.bookmark");
        _x.targetedVariations = targetedVariations;
        return _x;
    }

    @Property(name="targetedVariations")
    @JsonIgnore
    public CollectionPage<AnswerVariant> getTargetedVariations(HttpRequestOptions options) {
        return new CollectionPage<AnswerVariant>(contextPath, AnswerVariant.class, this.targetedVariations, Optional.ofNullable(targetedVariationsNextLink), Collections.emptyList(), options);
    }

    public Bookmark withUnmappedField(String name, Object value) {
        Bookmark _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bookmark patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Bookmark _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bookmark put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Bookmark _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Bookmark _copy() {
        Bookmark _x = new Bookmark();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedBy = lastModifiedBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.webUrl = webUrl;
        _x.availabilityEndDateTime = availabilityEndDateTime;
        _x.availabilityStartDateTime = availabilityStartDateTime;
        _x.categories = categories;
        _x.groupIds = groupIds;
        _x.isSuggested = isSuggested;
        _x.keywords = keywords;
        _x.languageTags = languageTags;
        _x.platforms = platforms;
        _x.powerAppIds = powerAppIds;
        _x.state = state;
        _x.targetedVariations = targetedVariations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Bookmark[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("availabilityEndDateTime=");
        b.append(this.availabilityEndDateTime);
        b.append(", ");
        b.append("availabilityStartDateTime=");
        b.append(this.availabilityStartDateTime);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("groupIds=");
        b.append(this.groupIds);
        b.append(", ");
        b.append("isSuggested=");
        b.append(this.isSuggested);
        b.append(", ");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("languageTags=");
        b.append(this.languageTags);
        b.append(", ");
        b.append("platforms=");
        b.append(this.platforms);
        b.append(", ");
        b.append("powerAppIds=");
        b.append(this.powerAppIds);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("targetedVariations=");
        b.append(this.targetedVariations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
