package microsoft.graph.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DevicePlatformType;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "languageTag", 
    "platform", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class AnswerVariant implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("languageTag")
    protected String languageTag;

    @JsonProperty("platform")
    protected DevicePlatformType platform;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected AnswerVariant() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.search.answerVariant";
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AnswerVariant withDescription(String description) {
        AnswerVariant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.answerVariant");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AnswerVariant withDisplayName(String displayName) {
        AnswerVariant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.answerVariant");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="languageTag")
    @JsonIgnore
    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(languageTag);
    }

    public AnswerVariant withLanguageTag(String languageTag) {
        AnswerVariant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.answerVariant");
        _x.languageTag = languageTag;
        return _x;
    }

    @Property(name="platform")
    @JsonIgnore
    public Optional<DevicePlatformType> getPlatform() {
        return Optional.ofNullable(platform);
    }

    public AnswerVariant withPlatform(DevicePlatformType platform) {
        AnswerVariant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.answerVariant");
        _x.platform = platform;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public AnswerVariant withWebUrl(String webUrl) {
        AnswerVariant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.answerVariant");
        _x.webUrl = webUrl;
        return _x;
    }

    public AnswerVariant withUnmappedField(String name, Object value) {
        AnswerVariant _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String displayName;
        private String languageTag;
        private DevicePlatformType platform;
        private String webUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder languageTag(String languageTag) {
            this.languageTag = languageTag;
            this.changedFields = changedFields.add("languageTag");
            return this;
        }

        public Builder platform(DevicePlatformType platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public AnswerVariant build() {
            AnswerVariant _x = new AnswerVariant();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.search.answerVariant";
            _x.description = description;
            _x.displayName = displayName;
            _x.languageTag = languageTag;
            _x.platform = platform;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private AnswerVariant _copy() {
        AnswerVariant _x = new AnswerVariant();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x.displayName = displayName;
        _x.languageTag = languageTag;
        _x.platform = platform;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AnswerVariant[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("languageTag=");
        b.append(this.languageTag);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
