package microsoft.graph.search.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.graph.search.entity.Qna;
import microsoft.graph.search.entity.request.QnaEntityRequest;

public class QnaCollectionRequest extends CollectionPageEntityRequest<Qna, QnaEntityRequest>{

    protected ContextPath contextPath;

    public QnaCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Qna.class, cp -> new QnaEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
