package microsoft.graph.externalconnectors.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IdentityType implements Enum {

    @JsonProperty("user")
    USER("user", "1"),

    @JsonProperty("group")
    GROUP("group", "2"),

    @JsonProperty("externalGroup")
    EXTERNAL_GROUP("externalGroup", "3"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private IdentityType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
