package microsoft.graph.externalconnectors.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.externalconnectors.collection.request.ExternalConnectionCollectionRequest;
import microsoft.graph.externalconnectors.entity.External;

@JsonIgnoreType
public class ExternalEntityRequest extends EntityRequest<External> {

    public ExternalEntityRequest(ContextPath contextPath, Optional<Object> value) {
        super(External.class, contextPath, value, false);
    }

    public ExternalConnectionEntityRequest connections(String id) {
        return new ExternalConnectionEntityRequest(contextPath.addSegment("connections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalConnectionCollectionRequest connections() {
        return new ExternalConnectionCollectionRequest(
                        contextPath.addSegment("connections"), Optional.empty());
    }

}
