package microsoft.graph.externalconnectors.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.externalconnectors.collection.request.ConnectionOperationCollectionRequest;
import microsoft.graph.externalconnectors.collection.request.ExternalGroupCollectionRequest;
import microsoft.graph.externalconnectors.collection.request.ExternalItemCollectionRequest;
import microsoft.graph.externalconnectors.entity.ExternalConnection;

@JsonIgnoreType
public class ExternalConnectionEntityRequest extends EntityRequest<ExternalConnection> {

    public ExternalConnectionEntityRequest(ContextPath contextPath, Optional<Object> value) {
        super(ExternalConnection.class, contextPath, value, false);
    }

    public ExternalGroupEntityRequest groups(String id) {
        return new ExternalGroupEntityRequest(contextPath.addSegment("groups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalGroupCollectionRequest groups() {
        return new ExternalGroupCollectionRequest(
                        contextPath.addSegment("groups"), Optional.empty());
    }

    public ExternalItemEntityRequest items(String id) {
        return new ExternalItemEntityRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalItemCollectionRequest items() {
        return new ExternalItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.empty());
    }

    public ConnectionOperationEntityRequest operations(String id) {
        return new ConnectionOperationEntityRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectionOperationCollectionRequest operations() {
        return new ConnectionOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public ConnectionQuotaEntityRequest quota() {
        return new ConnectionQuotaEntityRequest(contextPath.addSegment("quota"), Optional.empty());
    }

    public SchemaEntityRequest schema() {
        return new SchemaEntityRequest(contextPath.addSegment("schema"), Optional.empty());
    }

}
