package microsoft.graph.externalconnectors.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import microsoft.graph.externalconnectors.collection.request.ConnectionOperationCollectionRequest;
import microsoft.graph.externalconnectors.collection.request.ExternalGroupCollectionRequest;
import microsoft.graph.externalconnectors.collection.request.ExternalItemCollectionRequest;
import microsoft.graph.externalconnectors.complex.Configuration;
import microsoft.graph.externalconnectors.complex.SearchSettings;
import microsoft.graph.externalconnectors.entity.request.ConnectionQuotaEntityRequest;
import microsoft.graph.externalconnectors.entity.request.SchemaEntityRequest;
import microsoft.graph.externalconnectors.enums.ConnectionState;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "configuration", 
    "connectorId", 
    "description", 
    "ingestedItemsCount", 
    "name", 
    "searchSettings", 
    "state", 
    "groups", 
    "items", 
    "operations", 
    "schema"})
@JsonInclude(Include.NON_NULL)
public class ExternalConnection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnectors.externalConnection";
    }

    @JsonProperty("configuration")
    protected Configuration configuration;

    @JsonProperty("connectorId")
    protected String connectorId;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("ingestedItemsCount")
    protected Long ingestedItemsCount;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("searchSettings")
    protected SearchSettings searchSettings;

    @JsonProperty("state")
    protected ConnectionState state;

    @JsonProperty("groups")
    protected List<ExternalGroup> groups;

    @JsonProperty("items")
    protected List<ExternalItem> items;

    @JsonProperty("operations")
    protected List<ConnectionOperation> operations;

    @JsonProperty("schema")
    protected Schema schema;

    protected ExternalConnection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExternalConnection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Configuration configuration;
        private String connectorId;
        private String description;
        private Long ingestedItemsCount;
        private String name;
        private SearchSettings searchSettings;
        private ConnectionState state;
        private List<ExternalGroup> groups;
        private List<ExternalItem> items;
        private List<ConnectionOperation> operations;
        private Schema schema;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            this.changedFields = changedFields.add("configuration");
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            this.changedFields = changedFields.add("connectorId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder ingestedItemsCount(Long ingestedItemsCount) {
            this.ingestedItemsCount = ingestedItemsCount;
            this.changedFields = changedFields.add("ingestedItemsCount");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder searchSettings(SearchSettings searchSettings) {
            this.searchSettings = searchSettings;
            this.changedFields = changedFields.add("searchSettings");
            return this;
        }

        public Builder state(ConnectionState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder groups(List<ExternalGroup> groups) {
            this.groups = groups;
            this.changedFields = changedFields.add("groups");
            return this;
        }

        public Builder groups(ExternalGroup... groups) {
            return groups(Arrays.asList(groups));
        }

        public Builder items(List<ExternalItem> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        public Builder items(ExternalItem... items) {
            return items(Arrays.asList(items));
        }

        public Builder operations(List<ConnectionOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(ConnectionOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            this.changedFields = changedFields.add("schema");
            return this;
        }

        public ExternalConnection build() {
            ExternalConnection _x = new ExternalConnection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalConnectors.externalConnection";
            _x.id = id;
            _x.configuration = configuration;
            _x.connectorId = connectorId;
            _x.description = description;
            _x.ingestedItemsCount = ingestedItemsCount;
            _x.name = name;
            _x.searchSettings = searchSettings;
            _x.state = state;
            _x.groups = groups;
            _x.items = items;
            _x.operations = operations;
            _x.schema = schema;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="configuration")
    @JsonIgnore
    public Optional<Configuration> getConfiguration() {
        return Optional.ofNullable(configuration);
    }

    public ExternalConnection withConfiguration(Configuration configuration) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("configuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.configuration = configuration;
        return _x;
    }

    @Property(name="connectorId")
    @JsonIgnore
    public Optional<String> getConnectorId() {
        return Optional.ofNullable(connectorId);
    }

    public ExternalConnection withConnectorId(String connectorId) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("connectorId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.connectorId = connectorId;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ExternalConnection withDescription(String description) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.description = description;
        return _x;
    }

    @Property(name="ingestedItemsCount")
    @JsonIgnore
    public Optional<Long> getIngestedItemsCount() {
        return Optional.ofNullable(ingestedItemsCount);
    }

    public ExternalConnection withIngestedItemsCount(Long ingestedItemsCount) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("ingestedItemsCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.ingestedItemsCount = ingestedItemsCount;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ExternalConnection withName(String name) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.name = name;
        return _x;
    }

    @Property(name="searchSettings")
    @JsonIgnore
    public Optional<SearchSettings> getSearchSettings() {
        return Optional.ofNullable(searchSettings);
    }

    public ExternalConnection withSearchSettings(SearchSettings searchSettings) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("searchSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.searchSettings = searchSettings;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<ConnectionState> getState() {
        return Optional.ofNullable(state);
    }

    public ExternalConnection withState(ConnectionState state) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.state = state;
        return _x;
    }

    public ExternalConnection withUnmappedField(String name, Object value) {
        ExternalConnection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="groups")
    @JsonIgnore
    public ExternalGroupCollectionRequest getGroups() {
        return new ExternalGroupCollectionRequest(
                        contextPath.addSegment("groups"), Optional.ofNullable(groups));
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public ExternalItemCollectionRequest getItems() {
        return new ExternalItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.ofNullable(items));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public ConnectionOperationCollectionRequest getOperations() {
        return new ConnectionOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="quota")
    @JsonIgnore
    public ConnectionQuotaEntityRequest getQuota() {
        return new ConnectionQuotaEntityRequest(contextPath.addSegment("quota"), RequestHelper.getValue(unmappedFields, "quota"));
    }

    @NavigationProperty(name="schema")
    @JsonIgnore
    public SchemaEntityRequest getSchema() {
        return new SchemaEntityRequest(contextPath.addSegment("schema"), Optional.ofNullable(schema));
    }

    public ExternalConnection withGroups(List<ExternalGroup> groups) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("groups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.groups = groups;
        return _x;
    }

    public ExternalConnection withItems(List<ExternalItem> items) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.items = items;
        return _x;
    }

    public ExternalConnection withOperations(List<ConnectionOperation> operations) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.operations = operations;
        return _x;
    }

    public ExternalConnection withSchema(Schema schema) {
        ExternalConnection _x = _copy();
        _x.changedFields = changedFields.add("schema");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.externalConnection");
        _x.schema = schema;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalConnection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ExternalConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ExternalConnection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ExternalConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ExternalConnection _copy() {
        ExternalConnection _x = new ExternalConnection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.configuration = configuration;
        _x.connectorId = connectorId;
        _x.description = description;
        _x.ingestedItemsCount = ingestedItemsCount;
        _x.name = name;
        _x.searchSettings = searchSettings;
        _x.state = state;
        _x.groups = groups;
        _x.items = items;
        _x.operations = operations;
        _x.schema = schema;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExternalConnection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("configuration=");
        b.append(this.configuration);
        b.append(", ");
        b.append("connectorId=");
        b.append(this.connectorId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("ingestedItemsCount=");
        b.append(this.ingestedItemsCount);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("searchSettings=");
        b.append(this.searchSettings);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("groups=");
        b.append(this.groups);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("schema=");
        b.append(this.schema);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
