package microsoft.graph.externalconnectors.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "searchResultTemplates"})
@JsonInclude(Include.NON_NULL)
public class SearchSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("searchResultTemplates")
    protected List<DisplayTemplate> searchResultTemplates;

    @JsonProperty("searchResultTemplates@nextLink")
    protected String searchResultTemplatesNextLink;

    protected SearchSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnectors.searchSettings";
    }

    @Property(name="searchResultTemplates")
    @JsonIgnore
    public CollectionPage<DisplayTemplate> getSearchResultTemplates() {
        return new CollectionPage<DisplayTemplate>(contextPath, DisplayTemplate.class, this.searchResultTemplates, Optional.ofNullable(searchResultTemplatesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="searchResultTemplates")
    @JsonIgnore
    public CollectionPage<DisplayTemplate> getSearchResultTemplates(HttpRequestOptions options) {
        return new CollectionPage<DisplayTemplate>(contextPath, DisplayTemplate.class, this.searchResultTemplates, Optional.ofNullable(searchResultTemplatesNextLink), Collections.emptyList(), options);
    }

    public SearchSettings withUnmappedField(String name, Object value) {
        SearchSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DisplayTemplate> searchResultTemplates;
        private String searchResultTemplatesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder searchResultTemplates(List<DisplayTemplate> searchResultTemplates) {
            this.searchResultTemplates = searchResultTemplates;
            this.changedFields = changedFields.add("searchResultTemplates");
            return this;
        }

        public Builder searchResultTemplates(DisplayTemplate... searchResultTemplates) {
            return searchResultTemplates(Arrays.asList(searchResultTemplates));
        }

        public Builder searchResultTemplatesNextLink(String searchResultTemplatesNextLink) {
            this.searchResultTemplatesNextLink = searchResultTemplatesNextLink;
            this.changedFields = changedFields.add("searchResultTemplates");
            return this;
        }

        public SearchSettings build() {
            SearchSettings _x = new SearchSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalConnectors.searchSettings";
            _x.searchResultTemplates = searchResultTemplates;
            _x.searchResultTemplatesNextLink = searchResultTemplatesNextLink;
            return _x;
        }
    }

    private SearchSettings _copy() {
        SearchSettings _x = new SearchSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.searchResultTemplates = searchResultTemplates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SearchSettings[");
        b.append("searchResultTemplates=");
        b.append(this.searchResultTemplates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
