package microsoft.graph.externalconnectors.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.externalconnectors.enums.Label;
import microsoft.graph.externalconnectors.enums.PropertyType;

@JsonPropertyOrder({
    "@odata.type", 
    "aliases", 
    "isQueryable", 
    "isRefinable", 
    "isRetrievable", 
    "isSearchable", 
    "labels", 
    "name", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class Property implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("aliases")
    protected List<String> aliases;

    @JsonProperty("aliases@nextLink")
    protected String aliasesNextLink;

    @JsonProperty("isQueryable")
    protected Boolean isQueryable;

    @JsonProperty("isRefinable")
    protected Boolean isRefinable;

    @JsonProperty("isRetrievable")
    protected Boolean isRetrievable;

    @JsonProperty("isSearchable")
    protected Boolean isSearchable;

    @JsonProperty("labels")
    protected List<Label> labels;

    @JsonProperty("labels@nextLink")
    protected String labelsNextLink;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("type")
    protected PropertyType type;

    protected Property() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnectors.property";
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="aliases")
    @JsonIgnore
    public CollectionPage<String> getAliases() {
        return new CollectionPage<String>(contextPath, String.class, this.aliases, Optional.ofNullable(aliasesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="aliases")
    @JsonIgnore
    public CollectionPage<String> getAliases(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.aliases, Optional.ofNullable(aliasesNextLink), Collections.emptyList(), options);
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="isQueryable")
    @JsonIgnore
    public Optional<Boolean> getIsQueryable() {
        return Optional.ofNullable(isQueryable);
    }

    public Property withIsQueryable(Boolean isQueryable) {
        Property _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.property");
        _x.isQueryable = isQueryable;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="isRefinable")
    @JsonIgnore
    public Optional<Boolean> getIsRefinable() {
        return Optional.ofNullable(isRefinable);
    }

    public Property withIsRefinable(Boolean isRefinable) {
        Property _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.property");
        _x.isRefinable = isRefinable;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="isRetrievable")
    @JsonIgnore
    public Optional<Boolean> getIsRetrievable() {
        return Optional.ofNullable(isRetrievable);
    }

    public Property withIsRetrievable(Boolean isRetrievable) {
        Property _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.property");
        _x.isRetrievable = isRetrievable;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="isSearchable")
    @JsonIgnore
    public Optional<Boolean> getIsSearchable() {
        return Optional.ofNullable(isSearchable);
    }

    public Property withIsSearchable(Boolean isSearchable) {
        Property _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.property");
        _x.isSearchable = isSearchable;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="labels")
    @JsonIgnore
    public CollectionPage<Label> getLabels() {
        return new CollectionPage<Label>(contextPath, Label.class, this.labels, Optional.ofNullable(labelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="labels")
    @JsonIgnore
    public CollectionPage<Label> getLabels(HttpRequestOptions options) {
        return new CollectionPage<Label>(contextPath, Label.class, this.labels, Optional.ofNullable(labelsNextLink), Collections.emptyList(), options);
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Property withName(String name) {
        Property _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.property");
        _x.name = name;
        return _x;
    }

    @com.github.davidmoten.odata.client.annotation.Property(name="type")
    @JsonIgnore
    public Optional<PropertyType> getType() {
        return Optional.ofNullable(type);
    }

    public Property withType(PropertyType type) {
        Property _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.property");
        _x.type = type;
        return _x;
    }

    public Property withUnmappedField(String name, Object value) {
        Property _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> aliases;
        private String aliasesNextLink;
        private Boolean isQueryable;
        private Boolean isRefinable;
        private Boolean isRetrievable;
        private Boolean isSearchable;
        private List<Label> labels;
        private String labelsNextLink;
        private String name;
        private PropertyType type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder aliases(List<String> aliases) {
            this.aliases = aliases;
            this.changedFields = changedFields.add("aliases");
            return this;
        }

        public Builder aliases(String... aliases) {
            return aliases(Arrays.asList(aliases));
        }

        public Builder aliasesNextLink(String aliasesNextLink) {
            this.aliasesNextLink = aliasesNextLink;
            this.changedFields = changedFields.add("aliases");
            return this;
        }

        public Builder isQueryable(Boolean isQueryable) {
            this.isQueryable = isQueryable;
            this.changedFields = changedFields.add("isQueryable");
            return this;
        }

        public Builder isRefinable(Boolean isRefinable) {
            this.isRefinable = isRefinable;
            this.changedFields = changedFields.add("isRefinable");
            return this;
        }

        public Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            this.changedFields = changedFields.add("isRetrievable");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder labels(List<Label> labels) {
            this.labels = labels;
            this.changedFields = changedFields.add("labels");
            return this;
        }

        public Builder labels(Label... labels) {
            return labels(Arrays.asList(labels));
        }

        public Builder labelsNextLink(String labelsNextLink) {
            this.labelsNextLink = labelsNextLink;
            this.changedFields = changedFields.add("labels");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder type(PropertyType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Property build() {
            Property _x = new Property();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalConnectors.property";
            _x.aliases = aliases;
            _x.aliasesNextLink = aliasesNextLink;
            _x.isQueryable = isQueryable;
            _x.isRefinable = isRefinable;
            _x.isRetrievable = isRetrievable;
            _x.isSearchable = isSearchable;
            _x.labels = labels;
            _x.labelsNextLink = labelsNextLink;
            _x.name = name;
            _x.type = type;
            return _x;
        }
    }

    private Property _copy() {
        Property _x = new Property();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.aliases = aliases;
        _x.isQueryable = isQueryable;
        _x.isRefinable = isRefinable;
        _x.isRetrievable = isRetrievable;
        _x.isSearchable = isSearchable;
        _x.labels = labels;
        _x.name = name;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Property[");
        b.append("aliases=");
        b.append(this.aliases);
        b.append(", ");
        b.append("isQueryable=");
        b.append(this.isQueryable);
        b.append(", ");
        b.append("isRefinable=");
        b.append(this.isRefinable);
        b.append(", ");
        b.append("isRetrievable=");
        b.append(this.isRetrievable);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("labels=");
        b.append(this.labels);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
