package microsoft.graph.externalconnectors.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.graph.externalconnectors.entity.Identity;
import microsoft.graph.externalconnectors.entity.request.IdentityEntityRequest;

public class IdentityCollectionRequest extends CollectionPageEntityRequest<Identity, IdentityEntityRequest>{

    protected ContextPath contextPath;

    public IdentityCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Identity.class, cp -> new IdentityEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
