package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WorkforceIntegrationSupportedEntities implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("shift")
    SHIFT("shift", "1"),

    @JsonProperty("swapRequest")
    SWAP_REQUEST("swapRequest", "2"),

    @JsonProperty("userShiftPreferences")
    USER_SHIFT_PREFERENCES("userShiftPreferences", "8"),

    @JsonProperty("openShift")
    OPEN_SHIFT("openShift", "16"),

    @JsonProperty("openShiftRequest")
    OPEN_SHIFT_REQUEST("openShiftRequest", "32"),

    @JsonProperty("offerShiftRequest")
    OFFER_SHIFT_REQUEST("offerShiftRequest", "64"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "1024");

    private final String name;
    private final String value;

    private WorkforceIntegrationSupportedEntities(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
