package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsUpdateStatus implements Enum {

    @JsonProperty("upToDate")
    UP_TO_DATE("upToDate", "0"),

    @JsonProperty("pendingInstallation")
    PENDING_INSTALLATION("pendingInstallation", "1"),

    @JsonProperty("pendingReboot")
    PENDING_REBOOT("pendingReboot", "2"),

    @JsonProperty("failed")
    FAILED("failed", "3");

    private final String name;
    private final String value;

    private WindowsUpdateStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
