package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsStartMenuModeType implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("fullScreen")
    FULL_SCREEN("fullScreen", "1"),

    @JsonProperty("nonFullScreen")
    NON_FULL_SCREEN("nonFullScreen", "2");

    private final String name;
    private final String value;

    private WindowsStartMenuModeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
