package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsSpotlightEnablementSettings implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("disabled")
    DISABLED("disabled", "1"),

    @JsonProperty("enabled")
    ENABLED("enabled", "2");

    private final String name;
    private final String value;

    private WindowsSpotlightEnablementSettings(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
