package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsPrivacyDataCategory implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("accountInfo")
    ACCOUNT_INFO("accountInfo", "1"),

    @JsonProperty("appsRunInBackground")
    APPS_RUN_IN_BACKGROUND("appsRunInBackground", "2"),

    @JsonProperty("calendar")
    CALENDAR("calendar", "3"),

    @JsonProperty("callHistory")
    CALL_HISTORY("callHistory", "4"),

    @JsonProperty("camera")
    CAMERA("camera", "5"),

    @JsonProperty("contacts")
    CONTACTS("contacts", "6"),

    @JsonProperty("diagnosticsInfo")
    DIAGNOSTICS_INFO("diagnosticsInfo", "7"),

    @JsonProperty("email")
    EMAIL("email", "8"),

    @JsonProperty("location")
    LOCATION("location", "9"),

    @JsonProperty("messaging")
    MESSAGING("messaging", "10"),

    @JsonProperty("microphone")
    MICROPHONE("microphone", "11"),

    @JsonProperty("motion")
    MOTION("motion", "12"),

    @JsonProperty("notifications")
    NOTIFICATIONS("notifications", "13"),

    @JsonProperty("phone")
    PHONE("phone", "14"),

    @JsonProperty("radios")
    RADIOS("radios", "15"),

    @JsonProperty("tasks")
    TASKS("tasks", "16"),

    @JsonProperty("syncWithDevices")
    SYNC_WITH_DEVICES("syncWithDevices", "17"),

    @JsonProperty("trustedDevices")
    TRUSTED_DEVICES("trustedDevices", "18");

    private final String name;
    private final String value;

    private WindowsPrivacyDataCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
