package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsMalwareState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("detected")
    DETECTED("detected", "1"),

    @JsonProperty("cleaned")
    CLEANED("cleaned", "2"),

    @JsonProperty("quarantined")
    QUARANTINED("quarantined", "3"),

    @JsonProperty("removed")
    REMOVED("removed", "4"),

    @JsonProperty("allowed")
    ALLOWED("allowed", "5"),

    @JsonProperty("blocked")
    BLOCKED("blocked", "6"),

    @JsonProperty("cleanFailed")
    CLEAN_FAILED("cleanFailed", "102"),

    @JsonProperty("quarantineFailed")
    QUARANTINE_FAILED("quarantineFailed", "103"),

    @JsonProperty("removeFailed")
    REMOVE_FAILED("removeFailed", "104"),

    @JsonProperty("allowFailed")
    ALLOW_FAILED("allowFailed", "105"),

    @JsonProperty("abandoned")
    ABANDONED("abandoned", "106"),

    @JsonProperty("blockFailed")
    BLOCK_FAILED("blockFailed", "107");

    private final String name;
    private final String value;

    private WindowsMalwareState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
