package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsMalwareSeverity implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("low")
    LOW("low", "1"),

    @JsonProperty("moderate")
    MODERATE("moderate", "2"),

    @JsonProperty("high")
    HIGH("high", "4"),

    @JsonProperty("severe")
    SEVERE("severe", "5");

    private final String name;
    private final String value;

    private WindowsMalwareSeverity(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
