package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsInformationProtectionPinCharacterRequirements implements Enum {

    @JsonProperty("notAllow")
    NOT_ALLOW("notAllow", "0"),

    @JsonProperty("requireAtLeastOne")
    REQUIRE_AT_LEAST_ONE("requireAtLeastOne", "1"),

    @JsonProperty("allow")
    ALLOW("allow", "2");

    private final String name;
    private final String value;

    private WindowsInformationProtectionPinCharacterRequirements(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
