package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsInformationProtectionEnforcementLevel implements Enum {

    @JsonProperty("noProtection")
    NO_PROTECTION("noProtection", "0"),

    @JsonProperty("encryptAndAuditOnly")
    ENCRYPT_AND_AUDIT_ONLY("encryptAndAuditOnly", "1"),

    @JsonProperty("encryptAuditAndPrompt")
    ENCRYPT_AUDIT_AND_PROMPT("encryptAuditAndPrompt", "2"),

    @JsonProperty("encryptAuditAndBlock")
    ENCRYPT_AUDIT_AND_BLOCK("encryptAuditAndBlock", "3");

    private final String name;
    private final String value;

    private WindowsInformationProtectionEnforcementLevel(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
