package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsHealthMonitoringScope implements Enum {

    @JsonProperty("undefined")
    UNDEFINED("undefined", "0"),

    @JsonProperty("healthMonitoring")
    HEALTH_MONITORING("healthMonitoring", "1"),

    @JsonProperty("bootPerformance")
    BOOT_PERFORMANCE("bootPerformance", "2"),

    @JsonProperty("userExperienceAnalytics")
    USER_EXPERIENCE_ANALYTICS("userExperienceAnalytics", "4");

    private final String name;
    private final String value;

    private WindowsHealthMonitoringScope(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
