package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsFirewallRuleNetworkProfileTypes implements Enum {

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "0"),

    @JsonProperty("domain")
    DOMAIN("domain", "1"),

    @JsonProperty("private")
    PRIVATE("private", "2"),

    @JsonProperty("public")
    PUBLIC("public", "4");

    private final String name;
    private final String value;

    private WindowsFirewallRuleNetworkProfileTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
