package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsDeviceHealthState implements Enum {

    @JsonProperty("clean")
    CLEAN("clean", "0"),

    @JsonProperty("fullScanPending")
    FULL_SCAN_PENDING("fullScanPending", "1"),

    @JsonProperty("rebootPending")
    REBOOT_PENDING("rebootPending", "2"),

    @JsonProperty("manualStepsPending")
    MANUAL_STEPS_PENDING("manualStepsPending", "4"),

    @JsonProperty("offlineScanPending")
    OFFLINE_SCAN_PENDING("offlineScanPending", "8"),

    @JsonProperty("critical")
    CRITICAL("critical", "16");

    private final String name;
    private final String value;

    private WindowsDeviceHealthState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
