package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsDeliveryOptimizationMode implements Enum {

    @JsonProperty("userDefined")
    USER_DEFINED("userDefined", "0"),

    @JsonProperty("httpOnly")
    HTTP_ONLY("httpOnly", "1"),

    @JsonProperty("httpWithPeeringNat")
    HTTP_WITH_PEERING_NAT("httpWithPeeringNat", "2"),

    @JsonProperty("httpWithPeeringPrivateGroup")
    HTTP_WITH_PEERING_PRIVATE_GROUP("httpWithPeeringPrivateGroup", "3"),

    @JsonProperty("httpWithInternetPeering")
    HTTP_WITH_INTERNET_PEERING("httpWithInternetPeering", "4"),

    @JsonProperty("simpleDownload")
    SIMPLE_DOWNLOAD("simpleDownload", "99"),

    @JsonProperty("bypassMode")
    BYPASS_MODE("bypassMode", "100");

    private final String name;
    private final String value;

    private WindowsDeliveryOptimizationMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
