package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsAutopilotProfileAssignmentDetailedStatus implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("hardwareRequirementsNotMet")
    HARDWARE_REQUIREMENTS_NOT_MET("hardwareRequirementsNotMet", "1"),

    @JsonProperty("surfaceHubProfileNotSupported")
    SURFACE_HUB_PROFILE_NOT_SUPPORTED("surfaceHubProfileNotSupported", "2"),

    @JsonProperty("holoLensProfileNotSupported")
    HOLO_LENS_PROFILE_NOT_SUPPORTED("holoLensProfileNotSupported", "3"),

    @JsonProperty("windowsPcProfileNotSupported")
    WINDOWS_PC_PROFILE_NOT_SUPPORTED("windowsPcProfileNotSupported", "4");

    private final String name;
    private final String value;

    private WindowsAutopilotProfileAssignmentDetailedStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
