package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsAutopilotEnrollmentType implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("azureADJoinedWithAutopilotProfile")
    AZURE_ADJOINED_WITH_AUTOPILOT_PROFILE("azureADJoinedWithAutopilotProfile", "1"),

    @JsonProperty("offlineDomainJoined")
    OFFLINE_DOMAIN_JOINED("offlineDomainJoined", "2"),

    @JsonProperty("azureADJoinedUsingDeviceAuthWithAutopilotProfile")
    AZURE_ADJOINED_USING_DEVICE_AUTH_WITH_AUTOPILOT_PROFILE("azureADJoinedUsingDeviceAuthWithAutopilotProfile", "3"),

    @JsonProperty("azureADJoinedUsingDeviceAuthWithoutAutopilotProfile")
    AZURE_ADJOINED_USING_DEVICE_AUTH_WITHOUT_AUTOPILOT_PROFILE("azureADJoinedUsingDeviceAuthWithoutAutopilotProfile", "4"),

    @JsonProperty("azureADJoinedWithOfflineAutopilotProfile")
    AZURE_ADJOINED_WITH_OFFLINE_AUTOPILOT_PROFILE("azureADJoinedWithOfflineAutopilotProfile", "5"),

    @JsonProperty("azureADJoinedWithWhiteGlove")
    AZURE_ADJOINED_WITH_WHITE_GLOVE("azureADJoinedWithWhiteGlove", "6"),

    @JsonProperty("offlineDomainJoinedWithWhiteGlove")
    OFFLINE_DOMAIN_JOINED_WITH_WHITE_GLOVE("offlineDomainJoinedWithWhiteGlove", "7"),

    @JsonProperty("offlineDomainJoinedWithOfflineAutopilotProfile")
    OFFLINE_DOMAIN_JOINED_WITH_OFFLINE_AUTOPILOT_PROFILE("offlineDomainJoinedWithOfflineAutopilotProfile", "8");

    private final String name;
    private final String value;

    private WindowsAutopilotEnrollmentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
