package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsAutopilotDeviceType implements Enum {

    @JsonProperty("windowsPc")
    WINDOWS_PC("windowsPc", "0"),

    @JsonProperty("surfaceHub2")
    SURFACE_HUB2("surfaceHub2", "1"),

    @JsonProperty("holoLens")
    HOLO_LENS("holoLens", "2");

    private final String name;
    private final String value;

    private WindowsAutopilotDeviceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
