package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsAutopilotDeploymentState implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("success")
    SUCCESS("success", "1"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "2"),

    @JsonProperty("failure")
    FAILURE("failure", "3"),

    @JsonProperty("successWithTimeout")
    SUCCESS_WITH_TIMEOUT("successWithTimeout", "4");

    private final String name;
    private final String value;

    private WindowsAutopilotDeploymentState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
