package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum WindowsArchitecture implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("x86")
    X86("x86", "1"),

    @JsonProperty("x64")
    X64("x64", "2"),

    @JsonProperty("arm")
    ARM("arm", "4"),

    @JsonProperty("neutral")
    NEUTRAL("neutral", "8"),

    @JsonProperty("arm64")
    ARM64("arm64", "16");

    private final String name;
    private final String value;

    private WindowsArchitecture(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
