package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Windows10VpnProfileTarget implements Enum {

    @JsonProperty("user")
    USER("user", "0"),

    @JsonProperty("device")
    DEVICE("device", "1"),

    @JsonProperty("autoPilotDevice")
    AUTO_PILOT_DEVICE("autoPilotDevice", "2");

    private final String name;
    private final String value;

    private Windows10VpnProfileTarget(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
