package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Windows10EditionType implements Enum {

    @JsonProperty("windows10Enterprise")
    WINDOWS10ENTERPRISE("windows10Enterprise", "0"),

    @JsonProperty("windows10EnterpriseN")
    WINDOWS10ENTERPRISE_N("windows10EnterpriseN", "1"),

    @JsonProperty("windows10Education")
    WINDOWS10EDUCATION("windows10Education", "2"),

    @JsonProperty("windows10EducationN")
    WINDOWS10EDUCATION_N("windows10EducationN", "3"),

    @JsonProperty("windows10MobileEnterprise")
    WINDOWS10MOBILE_ENTERPRISE("windows10MobileEnterprise", "4"),

    @JsonProperty("windows10HolographicEnterprise")
    WINDOWS10HOLOGRAPHIC_ENTERPRISE("windows10HolographicEnterprise", "5"),

    @JsonProperty("windows10Professional")
    WINDOWS10PROFESSIONAL("windows10Professional", "6"),

    @JsonProperty("windows10ProfessionalN")
    WINDOWS10PROFESSIONAL_N("windows10ProfessionalN", "7"),

    @JsonProperty("windows10ProfessionalEducation")
    WINDOWS10PROFESSIONAL_EDUCATION("windows10ProfessionalEducation", "8"),

    @JsonProperty("windows10ProfessionalEducationN")
    WINDOWS10PROFESSIONAL_EDUCATION_N("windows10ProfessionalEducationN", "9"),

    @JsonProperty("windows10ProfessionalWorkstation")
    WINDOWS10PROFESSIONAL_WORKSTATION("windows10ProfessionalWorkstation", "10"),

    @JsonProperty("windows10ProfessionalWorkstationN")
    WINDOWS10PROFESSIONAL_WORKSTATION_N("windows10ProfessionalWorkstationN", "11"),

    @JsonProperty("notConfigured")
    NOT_CONFIGURED("notConfigured", "12"),

    @JsonProperty("windows10Home")
    WINDOWS10HOME("windows10Home", "13"),

    @JsonProperty("windows10HomeChina")
    WINDOWS10HOME_CHINA("windows10HomeChina", "14"),

    @JsonProperty("windows10HomeN")
    WINDOWS10HOME_N("windows10HomeN", "15"),

    @JsonProperty("windows10HomeSingleLanguage")
    WINDOWS10HOME_SINGLE_LANGUAGE("windows10HomeSingleLanguage", "16"),

    @JsonProperty("windows10Mobile")
    WINDOWS10MOBILE("windows10Mobile", "17"),

    @JsonProperty("windows10IoTCore")
    WINDOWS10IO_TCORE("windows10IoTCore", "18"),

    @JsonProperty("windows10IoTCoreCommercial")
    WINDOWS10IO_TCORE_COMMERCIAL("windows10IoTCoreCommercial", "19");

    private final String name;
    private final String value;

    private Windows10EditionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
