package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Windows10DeviceModeType implements Enum {

    @JsonProperty("standardConfiguration")
    STANDARD_CONFIGURATION("standardConfiguration", "0"),

    @JsonProperty("sModeConfiguration")
    S_MODE_CONFIGURATION("sModeConfiguration", "1");

    private final String name;
    private final String value;

    private Windows10DeviceModeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
