package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Windows10AppType implements Enum {

    @JsonProperty("desktop")
    DESKTOP("desktop", "0"),

    @JsonProperty("universal")
    UNIVERSAL("universal", "1");

    private final String name;
    private final String value;

    private Windows10AppType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
