package odata.msgraph.client.beta.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum Win32LobAppReturnCodeType implements Enum {

    @JsonProperty("failed")
    FAILED("failed", "0"),

    @JsonProperty("success")
    SUCCESS("success", "1"),

    @JsonProperty("softReboot")
    SOFT_REBOOT("softReboot", "2"),

    @JsonProperty("hardReboot")
    HARD_REBOOT("hardReboot", "3"),

    @JsonProperty("retry")
    RETRY("retry", "4");

    private final String name;
    private final String value;

    private Win32LobAppReturnCodeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
